/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
//@Interface(name = "service")
public interface ReceiverBehaviour extends Behaviour {

	// method used by an execution
	void setMessage(InternalMessage<?> message);

	InternalMessage<?> getMessage();

	// method used by the behaviour
	boolean accept(InternalMessage<?> message, ExternalContext context)
			throws CoreException;

	Node getChildNodeSelected();

	void addVariableName(QName variableName);

	List<QName> getVariableNames();
	
	MessageMatcher getMessageMatcher();

	void setMessageMatcher(MessageMatcher messageMatcher);

	List<CorrelationMatcher> getCorrelationsMatchers();
	
	void setCorrelationsMatchers(List<CorrelationMatcher> correlationMatcher);
	
	Object getClientEndpointKey();

	void setClientEndpointKey(Object endpoint);
	
//	boolean getCreateInstance();
//	
//	void setCreateInstance(boolean createInstance);
	
}
