/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.api.factory;

import java.util.HashMap;
import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class AbstractFactoryImpl {

	public static final String DEFAULT_FACTORY_NAME = "core";


	private static Logger log = Logger.getLogger(AbstractFactoryImpl.class
			.getName());

	private static Core core = null;

	protected Core createCore(final String name, final ConfigurationEngine configuration, Class<? extends Core> coreClass)
	throws CoreException {

		boolean explorer = false;
		if(configuration != null && configuration.getExplorer() != null) {
			explorer = configuration.getExplorer();
		}
		final Component coreComponent = this.createCoreComposite(explorer, coreClass);
		try {
			SCAHelper.getSCAHelper().startComponent(coreComponent);

			AbstractFactoryImpl.setCore(coreComponent);

			if (name != null) {
				SCAHelper.getSCAHelper().changeName(coreComponent,
						name);
			}

			AbstractFactoryImpl.setCore(coreComponent);
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		AbstractFactoryImpl.log.finest("core created and started");
		return core;
	}

	private static void setCore(final Component coreComponent)
	throws NoSuchInterfaceException, CoreException {
		//		core = (Core) coreComponent.getFcInterface("/content");
		SCAContentController scacc = (SCAContentController)
		coreComponent.getFcInterface(SCAContentController.NAME);
		try {
			core = (Core) scacc.getFcContent();
		}
		catch (ContentInstantiationException e) {
			throw new CoreException(e);
		}
		//		core.init(coreComponent);
	}

	/**
	 * Initialize core composite
	 * 
	 * @throws CoreException
	 * 
	 */
	private Component createCoreComposite(boolean explorer, Class<? extends Core> coreClass)
	throws CoreException {
		Component coreComponent = null;
		try {
			if (!explorer) {
				coreComponent = SCAHelper.getSCAHelper()
				.createNewComponent(coreClass.getName(), null);
			} else {
				final Component explorerComponent = SCAHelper.getSCAHelper()
				.createNewComponent(SCAHelper.CORE_EXPLORER_COMPOSITE,
						new HashMap<Object, Object>());

				SCAHelper.getSCAHelper().startComponent(explorerComponent);
				final Component explorerComp = SCAHelper.getSCAHelper()
				.getComponents(explorerComponent).get(0);

				final Component myExplorerComp = SCAHelper.getSCAHelper()
				.getComponents(explorerComp).get(1);

				coreComponent = SCAHelper.getSCAHelper().getComponents(
						myExplorerComp).get(1);
			}
			SCAHelper.getSCAHelper().changeName(coreComponent,
					AbstractFactoryImpl.DEFAULT_FACTORY_NAME);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return coreComponent;
	}


	public static Core getCore() {
		return core;
	}
}
