/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.factory;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import java.util.HashMap;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

public abstract class AbstractFactoryImpl {
    public static final String DEFAULT_FACTORY_NAME = "core";
    private static Logger log = Logger.getLogger(AbstractFactoryImpl.class.getName());
    private static Core core = null;

    protected Core createCore(String string, ConfigurationEngine configurationEngine, Class<? extends Core> clazz) throws CoreException {
        boolean bl = false;
        if (configurationEngine != null && configurationEngine.getExplorer() != null) {
            bl = configurationEngine.getExplorer();
        }
        Component component = this.createCoreComposite(bl, clazz);
        try {
            SCAHelper.getSCAHelper().startComponent(component);
            AbstractFactoryImpl.setCore(component);
            if (string != null) {
                SCAHelper.getSCAHelper().changeName(component, string);
            }
            AbstractFactoryImpl.setCore(component);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        catch (SCAException sCAException) {
            throw new CoreException(sCAException);
        }
        log.finest("core created and started");
        return core;
    }

    private static void setCore(Component component) throws NoSuchInterfaceException, CoreException {
        SCAContentController sCAContentController = (SCAContentController)component.getFcInterface("/sca-content-controller");
        try {
            core = (Core)sCAContentController.getFcContent();
        }
        catch (ContentInstantiationException contentInstantiationException) {
            throw new CoreException(contentInstantiationException);
        }
    }

    private Component createCoreComposite(boolean bl, Class<? extends Core> clazz) throws CoreException {
        Component component = null;
        try {
            if (!bl) {
                component = SCAHelper.getSCAHelper().createNewComponent(clazz.getName(), null);
            } else {
                Component component2 = SCAHelper.getSCAHelper().createNewComponent("CoreExplorer", new HashMap());
                SCAHelper.getSCAHelper().startComponent(component2);
                Component component3 = (Component)SCAHelper.getSCAHelper().getComponents(component2).get(0);
                Component component4 = (Component)SCAHelper.getSCAHelper().getComponents(component3).get(1);
                component = (Component)SCAHelper.getSCAHelper().getComponents(component4).get(1);
            }
            SCAHelper.getSCAHelper().changeName(component, DEFAULT_FACTORY_NAME);
        }
        catch (SCAException sCAException) {
            throw new CoreException(sCAException);
        }
        return component;
    }

    public static Core getCore() {
        return core;
    }
}

