/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.model.registry.definition;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysis;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.tools.ProcessForker;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

@Scope(value="COMPOSITE")
@Service(value={ProcessDefinitionRegistry.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public abstract class AbstractProcessDefinitionRegistry<Def extends ProcessDefinition>
extends SCAComponentImpl
implements ProcessDefinitionRegistry<Def> {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(AbstractProcessDefinitionRegistry.class.getName());
    protected Map<ProcessKey, Def> registry = new HashMap<ProcessKey, Def>();
    private StaticAnalysis staticAnalysis;
    private StaticAnalysisPrinter staticAnalysisPrinter;

    @Override
    public ProcessKey findProcessKey(QName qName) {
        ProcessKey processKey = null;
        for (Map.Entry<ProcessKey, Def> entry : this.registry.entrySet()) {
            if (!((ProcessDefinition)entry.getValue()).getQName().equals(qName)) continue;
            processKey = entry.getKey();
            break;
        }
        return processKey;
    }

    public Model getModel() throws CoreException {
        Model model = null;
        try {
            Component component = SCAHelper.getSCAHelper().getParent(this.getComponent());
            model = (Model)component.getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException(noSuchInterfaceException);
        }
        catch (SCAException sCAException) {
            throw new CoreException(sCAException);
        }
        return model;
    }

    @Override
    public StaticAnalysis getStaticAnalysis() {
        return this.staticAnalysis;
    }

    @Override
    public void setStaticAnalysis(StaticAnalysis staticAnalysis) {
        this.staticAnalysis = staticAnalysis;
    }

    @Override
    public StaticAnalysisPrinter getStaticAnalysisPrinter() {
        return this.staticAnalysisPrinter;
    }

    @Override
    public void setStaticAnalysisPrinter(StaticAnalysisPrinter staticAnalysisPrinter) {
        this.staticAnalysisPrinter = staticAnalysisPrinter;
    }

    @Override
    public synchronized ProcessDefinition storeProcessDefinition(URI uRI, ProcessContextDefinition processContextDefinition) throws CoreException {
        ProcessDefinition processDefinition = null;
        processDefinition = (ProcessDefinition)this.getModel().getCompiler().validate(uRI);
        log.finest("Number of process instances : " + this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances().size());
        if (this.getStaticAnalysis() != null && this.getStaticAnalysisPrinter() != null) {
            List<ProcessKey> list;
            if (this.getStaticAnalysis().getErrors().size() > 0) {
                String string = this.getStaticAnalysisPrinter().printAll(this.getStaticAnalysis().getErrors(), this.getStaticAnalysis().getWarnings(), this.getStaticAnalysis().getInfos());
                throw new CoreException("Compilation Error: " + string, (Throwable)this.getStaticAnalysis().getErrors().get(0).getError());
            }
            if (this.getStaticAnalysis().getWarnings().size() > 0) {
                list = this.getStaticAnalysisPrinter().printAll(this.getStaticAnalysis().getErrors(), this.getStaticAnalysis().getWarnings(), this.getStaticAnalysis().getInfos());
                log.finest("Compilation warning: " + (String)((Object)list));
            }
            list = null;
            list = this.createKeys(processDefinition);
            if (list == null || list.size() == 0) {
                throw new CoreException("The keys cannot be null");
            }
            String string = "\nList of key :\n";
            for (ProcessKey processKey : list) {
                string = string + processKey;
                this.registry.put(processKey, processDefinition);
            }
            log.finest(string);
            if (processContextDefinition.getPoolSize() > 0) {
                Process process = this.getModel().getCompiler().compile(processDefinition);
                process.run();
                log.info("First process started");
                for (int i = 1; i < processContextDefinition.getPoolSize(); ++i) {
                    ProcessForker processForker = new ProcessForker(i, processDefinition, this, list);
                    this.getModel().getCore().getEngine().getPoolOfProcessForkers().addProcessForkers(processForker);
                    processForker.start();
                    log.finest("process number" + i + " is going to be stored ...");
                }
            }
        } else {
            log.severe("StaticAnalysis and StaticAnalysisPrinter MUST be set for this definition model.");
        }
        return processDefinition;
    }

    @Override
    public void unStoreProcessDefinition(URI uRI, boolean bl) throws CoreException {
        ProcessDefinition processDefinition = null;
        processDefinition = (ProcessDefinition)this.getModel().getCompiler().validate(uRI);
        List<ProcessKey> list = null;
        list = this.createKeys(processDefinition);
        if (list != null) {
            for (ProcessKey processKey : list) {
                this.removeProcessDefinition(processKey, bl);
            }
        }
    }

    @Override
    public void setLog(Logger logger) {
        log = logger;
    }

    @Override
    public abstract List<ProcessKey> createKeys(ProcessDefinition var1) throws CoreException;

    @Override
    public abstract <D extends ProcessDefinition> boolean isCreateInstance(D var1, InternalMessage<?> var2) throws CoreException;
}

