/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.ExecutableElement;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Transition;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutableElementImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Contingency;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Membrane(controller="primitive")
public class TransitionImpl
extends ExecutableElementImpl
implements Transition,
BindingController,
LifeCycleController {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(TransitionImpl.class.getName());
    @Requires(contingency=Contingency.MANDATORY, name="source")
    private Node source;
    @Requires(contingency=Contingency.OPTIONAL, name="destination")
    private Node destination;
    @Requires(contingency=Contingency.OPTIONAL, name="execution")
    private Execution execution;
    @Controller
    private org.objectweb.fractal.api.Component component;

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void listFc(List<String> list) {
        if (this.execution != null) {
            list.add("execution");
        }
        if (this.destination != null) {
            list.add("destination");
        }
        if (this.source != null) {
            list.add("source");
        }
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("execution")) {
            return this.execution;
        }
        if (string.equals("destination")) {
            return this.destination;
        }
        if (string.equals("source")) {
            return this.source;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    public String getFcState() {
        return null;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        if (string.equals("execution")) {
            this.execution = (Execution)object;
            return;
        }
        if (string.equals("destination")) {
            this.destination = (Node)object;
            return;
        }
        if (string.equals("source")) {
            this.source = (Node)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("execution")) {
            this.execution = null;
            return;
        }
        if (string.equals("destination")) {
            this.destination = null;
            return;
        }
        if (string.equals("source")) {
            this.source = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        this.log.fine("Fractal transition created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        this.log.fine("Fractal transition initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        this.log.fine("Fractal transition started: " + this.getName());
    }

    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        this.log.finest("transition stopped: " + this.getName());
    }

    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        this.log.fine("Fractal transition destroyed: " + this.getName());
    }

    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    public Node getDestination() {
        return this.destination;
    }

    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    public void execute() throws CoreException {
        this.selectDefaultNextTarget();
        this.execution.next();
    }

    public List<ExecutableElement> selectDefaultNextTarget() throws CoreException {
        if (this.getNextSelectedExecutableElements().size() == 0) {
            this.getNextSelectedExecutableElements().add((ExecutableElement)this.destination);
        }
        return this.nextSelectedExecElmts;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }
}

