/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AssignBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Interface;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.types.Contingency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(provides={@Interface(name="service", signature=AssignBehaviour.class)})
public class AssignBehaviourImpl
extends AbstractBehaviourImpl
implements AssignBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(AssignBehaviourImpl.class.getName());
    @Requires(contingency=Contingency.OPTIONAL, name="node")
    protected Node node;
    private List<AssignementExpression> assignements = new ArrayList<AssignementExpression>();

    protected void listFc(List<String> list) {
        if (this.node != null) {
            list.add("node");
        }
        super.listFc(list);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            return this.node;
        }
        return super.lookupFc(string);
    }

    public Map<String, Object> getInitializationContext() throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("assignements", this.assignements);
        return hashMap;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = (Node)object;
            return;
        }
        super.bindFc(string, object);
    }

    public void setInitializationContext(Map<String, Object> map) throws CoreException {
        this.assignements = (List)map.get("assignements");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("node")) {
            this.node = null;
            return;
        }
        super.unbindFc(string);
    }

    public void executeActivity() throws CoreException {
        this.log.finest("start assign behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        this.affect();
        this.log.finest("end of assign behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_ENDED;
    }

    public Node getNode() {
        return this.node;
    }

    public String toString() {
        return "Assign";
    }

    public void affect() throws CoreException {
        if (this.assignements != null) {
            for (AssignementExpression assignementExpression : this.assignements) {
                if (assignementExpression == null || assignementExpression.getLeft() == null) {
                    throw new CoreException("The left assignement is null");
                }
                if (assignementExpression.getAssigner() == null) {
                    throw new CoreException("Error: the assigner cannot be null");
                }
                this.log.finest("set " + assignementExpression.getRight() + " in " + assignementExpression.getLeft());
                assignementExpression.getAssigner().affect(this.getNode().getExecution().getParentScope(), assignementExpression.getLeft(), assignementExpression.getRight());
            }
        }
    }

    public void addAssignementExpression(AssignementExpression assignementExpression) {
        this.assignements.add(assignementExpression);
    }

    public List<AssignementExpression> getAssignementExpressions() {
        return this.assignements;
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }
}

