/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.registry;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.registry.ProcessInstanceRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryProcessInstanceRegistryImpl
implements ProcessInstanceRegistry {
    private final Logger log = Logger.getLogger(MemoryProcessInstanceRegistryImpl.class.getName());
    private final Map<ProcessKey, List<Process>> map = new HashMap<ProcessKey, List<Process>>();
    private final Engine engine;

    public MemoryProcessInstanceRegistryImpl(Engine engine) {
        this.engine = engine;
    }

    public List<Process> getProcessInstances(InternalMessage<?> internalMessage) {
        ProcessKeyImpl processKeyImpl = new ProcessKeyImpl();
        processKeyImpl.setEndpoint(internalMessage.getEndpoint());
        processKeyImpl.setService(internalMessage.getService());
        this.log.finest("tried key : " + ((Object)processKeyImpl).toString());
        String string = null;
        Iterator<ProcessKey> iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            string = string == null ? iterator.next().toString() : String.valueOf(string) + ", " + iterator.next().toString();
        }
        this.log.finest("available keys : " + string);
        return this.map.get(processKeyImpl);
    }

    public List<Process> getProcessInstances(ProcessKey processKey) {
        List<Process> list = this.map.get(processKey);
        if (list == null) {
            list = new ArrayList<Process>();
        }
        return list;
    }

    public Process removeProcessInstance(Process process, boolean bl) throws CoreException {
        List list = process.getProcessKeys();
        for (ProcessKey processKey : list) {
            Iterator<Process> iterator;
            List<Process> list2 = this.map.get(processKey);
            Process process2 = null;
            if (list2 != null) {
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    process2 = iterator.next();
                    if (!process2.getName().equals(process.getName())) continue;
                    if (bl) {
                        list2.remove(process2);
                        this.engine.deleteProcess(process2);
                        iterator = list2.iterator();
                        break;
                    }
                    if (process2.getParentExecution() != null && process2.getParentExecution().getState() == Execution.State.ENDED || process2.getParentExecution() == null) {
                        list2.remove(process2);
                        this.engine.deleteProcess(process2);
                        iterator = list2.iterator();
                        break;
                    }
                    throw new CoreException("Impossible to remove this process instance (" + process2.getName() + ") because it is not ended: state = " + process2.getParentExecution().getState());
                }
            } else {
                this.log.finest("processes IS NULL ...");
            }
            iterator = this.map.get(processKey);
            if (iterator != null && iterator.size() != 0) continue;
            this.map.remove(processKey);
        }
        return process;
    }

    public void storeProcessInstance(ProcessKey processKey, Process process) throws CoreException {
        List<Process> list = this.map.get(processKey);
        if (list == null) {
            list = new ArrayList<Process>();
            this.map.put(processKey, list);
        }
        list.add(process);
        this.log.finest("instance stored: key = " + processKey + " - process: " + process.getName());
        this.log.finest("Number of process in key \"" + processKey + "\" : " + list.size());
    }

    public Map<ProcessKey, List<Process>> getMap() {
        return this.map;
    }

    public List<Process> getProcessInstances() {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        for (List<Process> list : this.map.values()) {
            for (Process process : list) {
                if (arrayList.contains(process)) continue;
                arrayList.add(process);
            }
        }
        return arrayList;
    }
}

