/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.env;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageConverter;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotations.Component;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Step;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Membrane(controller="composite")
public class ExternalEnvironmentImpl
implements ExternalEnvironment,
BindingController,
LifeCycleController {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_EXTERNAL_ENVIRONMENT_NAME = "ExternalEnvironment";
    private Logger log = Logger.getLogger(ExternalEnvironmentImpl.class.getName());
    private final List<org.objectweb.fractal.api.Component> receivers = new ArrayList<org.objectweb.fractal.api.Component>();
    private final List<org.objectweb.fractal.api.Component> senders = new ArrayList<org.objectweb.fractal.api.Component>();
    @Requires(name="engine")
    private Engine engine;
    @Controller
    private org.objectweb.fractal.api.Component component;

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFc(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void listFc(List<String> list) {
        if (this.engine != null) {
            list.add("engine");
        }
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("engine")) {
            return this.engine;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    protected void createFc() throws Throwable {
        this.create();
    }

    public String getFcState() {
        return null;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException {
        if (string.equals("component")) {
            this.component = (org.objectweb.fractal.api.Component)((org.objectweb.fractal.api.Component)object).getFcInterface("component");
        }
        if (string.equals("engine")) {
            this.engine = (Engine)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void unbindFc(String string) throws NoSuchInterfaceException {
        if (string.equals("engine")) {
            this.engine = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyFc();
    }

    protected void destroyFc() throws Throwable {
        this.destroy();
    }

    @Lifecycle(step=Step.CREATE)
    public void create() throws CoreException {
        this.log.fine("Fractal environment created: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    public void init(org.objectweb.fractal.api.Component component) throws CoreException {
        this.component = component;
        this.log.fine("Fractal environment initiated: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Lifecycle(step=Step.START)
    public void start() throws CoreException {
        this.log.fine("Fractal environment started: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Lifecycle(step=Step.STOP)
    public void stop() throws CoreException {
        this.log.fine("Fractal environment stopped: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    @Lifecycle(step=Step.DESTROY)
    public void destroy() throws CoreException {
        this.log.fine("Fractal environment destroyed: " + FractalHelper.getFractalHelper().getName(this.component));
    }

    public Receiver addReceiver(Class<? extends Receiver> clazz, MessageConverter messageConverter) throws CoreException {
        Receiver receiver = null;
        this.checkEngine();
        if (this.engine == null) {
            throw new CoreException("You must create the engine before create an receiver!!!");
        }
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().createNewComponent(clazz.getName(), null);
        FractalHelper.getFractalHelper().addComponent(component, this.component, null);
        this.receivers.add(component);
        try {
            receiver = (Receiver)component.getFcInterface("/content");
            receiver.init(component);
            receiver.setMessageConverter(messageConverter);
            if (!this.log.getName().equals(ExternalEnvironmentImpl.class.getName())) {
                receiver.setLog(this.log);
            }
            FractalHelper.getFractalHelper().startComponent(component);
            FractalHelper.getFractalHelper().changeName(component, String.valueOf(clazz.getSimpleName()) + "_" + this.receivers.size());
            receiver = (Receiver)component.getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        this.log.finest("receiver created and started");
        return receiver;
    }

    public org.objectweb.fractal.api.Component getComponent() {
        return this.component;
    }

    public String getName() throws CoreException {
        return FractalHelper.getFractalHelper().getName(this.component);
    }

    public void setName(String string) throws CoreException {
        if (string != null) {
            FractalHelper.getFractalHelper().changeName(this.component, string);
        }
    }

    public List<Receiver> getReceivers() throws CoreException {
        ArrayList<Receiver> arrayList = new ArrayList<Receiver>();
        for (org.objectweb.fractal.api.Component component : this.receivers) {
            try {
                arrayList.add((Receiver)component.getFcInterface("service"));
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                throw new CoreException((Throwable)noSuchInterfaceException);
            }
        }
        return arrayList;
    }

    public Sender addSender(Class<? extends Sender> clazz, MessageConverter messageConverter) throws CoreException {
        Sender sender = null;
        this.checkEngine();
        if (this.engine == null) {
            throw new CoreException("You must create the engine before create an sender!!!");
        }
        org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().createNewComponent(clazz.getName(), null);
        FractalHelper.getFractalHelper().addComponent(component, this.component, null);
        this.senders.add(component);
        try {
            sender = (Sender)component.getFcInterface("/content");
            sender.init(component);
            sender.setMessageConverter(messageConverter);
            if (!this.log.getName().equals(ExternalEnvironmentImpl.class.getName())) {
                sender.setLog(this.log);
            }
            FractalHelper.getFractalHelper().startComponent(component);
            FractalHelper.getFractalHelper().changeName(component, String.valueOf(clazz.getSimpleName()) + "_" + this.senders.size());
            sender = (Sender)component.getFcInterface("service");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
        this.log.finest("sender created and started");
        return sender;
    }

    public List<Sender> getSenders() throws CoreException {
        ArrayList<Sender> arrayList = new ArrayList<Sender>();
        for (org.objectweb.fractal.api.Component component : this.senders) {
            try {
                arrayList.add((Sender)component.getFcInterface("service"));
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                throw new CoreException((Throwable)noSuchInterfaceException);
            }
        }
        return arrayList;
    }

    private void checkEngine() throws CoreException {
        try {
            if (this.engine == null) {
                org.objectweb.fractal.api.Component component = FractalHelper.getFractalHelper().getParent(this.getComponent());
                Core core = (Core)component.getFcInterface("service");
                this.engine = core.getEngine();
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            throw new CoreException((Throwable)noSuchInterfaceException);
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }
}

