/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader.copy;

import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.impl.util.jarLoader.copy.JarLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarLoaderManager {
    private Logger log = Logger.getLogger(JarLoaderManager.class.getCanonicalName());
    private static JarLoaderManager instance = null;

    public static JarLoaderManager getInstance() {
        if (instance == null) {
            instance = new JarLoaderManager();
        }
        return instance;
    }

    private JarLoaderManager() {
    }

    public List<JarLoader> getJarList(String dir, boolean recur, ClassLoader parent) {
        List<File> files = this.getJarListInString(dir, recur);
        return this.getJarList(files, parent);
    }

    private List<File> getJarListInString(String dir, boolean recur) {
        ArrayList<File> vjl = new ArrayList<File>();
        File pgDir = new File(dir);
        File[] ls = pgDir.listFiles();
        if (ls == null || ls.length == 0) {
            return null;
        }
        for (File f : ls) {
            if (f.isFile() && f.getName().endsWith("jar")) {
                vjl.add(f);
                continue;
            }
            if (!f.isDirectory() || !recur) continue;
            vjl.addAll(this.getJarListInString(f.getAbsolutePath(), true));
        }
        return vjl;
    }

    public List<JarLoader> getJarList(List<File> jars, ClassLoader parent) {
        ArrayList<JarLoader> vjl = new ArrayList<JarLoader>();
        if (jars != null) {
            for (File f : jars) {
                if (!f.isFile() || !f.getName().endsWith("jar")) continue;
                try {
                    new JarFile(f);
                    vjl.add(new JarLoader(f, parent));
                }
                catch (IOException e) {}
            }
        }
        return vjl;
    }

    public ClassLoader createNewClassLoader(String jarString, ClassLoader parent) {
        ClassLoader res = parent;
        List<File> orderedClasspath = this.extractJarFileFromManifest(jarString);
        List<File> jar2reload = this.jar2Reload(orderedClasspath, parent);
        while (jar2reload.size() > 0) {
            jar2reload = this.jar2Reload(jar2reload, parent);
        }
        return res;
    }

    private List<File> extractJarFileFromManifest(String jarString) {
        Attributes attr;
        ArrayList<File> orderedClasspath = new ArrayList<File>();
        File jarFile = new File(jarString);
        JarLoader jar = new JarLoader(jarFile, null);
        if (jar.getManifest() != null && (attr = jar.getManifest().getMainAttributes()) != null && attr.getValue("Class-Path") != null) {
            StringTokenizer st = new StringTokenizer(attr.getValue("Class-Path"), " ");
            ArrayList<String> classpath = new ArrayList<String>();
            while (st.hasMoreElements()) {
                classpath.add(jarFile.getAbsolutePath().substring(0, jarFile.getAbsolutePath().lastIndexOf(File.separatorChar) + 1) + st.nextToken());
            }
            System.out.println("classpath = " + classpath);
            classpath.add(0, jarString);
            for (String file : classpath) {
                orderedClasspath.add(0, new File(file));
            }
            System.out.println("orderedClasspath = " + orderedClasspath);
        }
        return orderedClasspath;
    }

    private List<File> jar2Reload(List<File> jars, ClassLoader parent) {
        ArrayList<File> jar2reload = new ArrayList<File>();
        for (File jar : jars) {
            try {
                parent = new JarLoader(jar, parent);
                ((JarLoader)parent).makeJarClassList();
            }
            catch (NoClassDefFoundError e) {
                this.log.warning("Impossible to load this jar for the moment: " + jar);
                jar2reload.add(jar);
            }
        }
        return jar2reload;
    }
}

