/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import static org.objectweb.fractal.fraclet.types.Step.CREATE;
import static org.objectweb.fractal.fraclet.types.Step.DESTROY;
import static org.objectweb.fractal.fraclet.types.Step.START;
import static org.objectweb.fractal.fraclet.types.Step.STOP;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Controller;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.extensions.Membrane;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.fractal.FractalHelper;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.objectweb.fractal.fraclet.annotations.Component
@Membrane(controller="composite")
public class ExecutionEnvironmentTestImpl implements ExecutionEnvironmentTest {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ExecutionEnvironmentTestImpl.class.getName());


	/**
	 * The component.
	 */
	@Controller
	private Component component;


	private Core core;

	private List<ClientEndpoint> clientEndpoints = new ArrayList<ClientEndpoint>();

	private List<ProviderEndpoint> providerEndpoints = new ArrayList<ProviderEndpoint>();

	/**
	 * Default constructor
	 * @throws CoreException
	 */
	public ExecutionEnvironmentTestImpl()  {
		super();
	}

	/**
	 * Create the scope behaviour
	 * @throws CoreException
	 */
	@Lifecycle(step = CREATE)
	public void create() throws CoreException {
		log.fine("Fractal execution environment created: " + FractalHelper.getFractalHelper().getName(this.component));
	}

	public void init(Component fractalNode) throws CoreException {
		this.component = fractalNode;
		log.fine("Fractal execution environment initiated: " + FractalHelper.getFractalHelper().getName(this.component));
	}

	/**
	 * Start the NodeImpl behaviour
	 * @throws CoreException
	 */
	@Lifecycle(step = START)
	public void start() throws CoreException {
		log.fine("Fractal execution environment started: " + this.getName());
	}

	/**
	 * Stop the NodeImpl behaviour
	 * @throws CoreException
	 */
	@Lifecycle(step = STOP)
	public void stop() throws CoreException {
		log.finest("transition stopped: " + this.getName());
	}

	/**
	 * Destroy the NodeImpl behaviour
	 * @throws CoreException
	 */
	@Lifecycle(step = DESTROY)
	public void destroy() throws CoreException {
		log.fine("Fractal execution environment endpoint destroyed: " + this.getName());
	}

	public Component getComponent() {
		return this.component;
	}


	public String getName() throws CoreException {
		return FractalHelper.getFractalHelper().getName(this.component);
	}

	public void setName(String name) throws CoreException {
		if(name != null)
			FractalHelper.getFractalHelper().changeName(this.component, name);
	}

	public void addClientEndpoint(ClientEndpoint cep) throws CoreException {
		FractalHelper.getFractalHelper().addComponent(cep.getComponent(), this.getComponent(), null);
		this.clientEndpoints.add(cep);
	}

	public void addProviderEndpoint(ProviderEndpoint pep) throws CoreException {
		FractalHelper.getFractalHelper().addComponent(pep.getComponent(), this.getComponent(), null);
		this.providerEndpoints.add(pep);
	}

	public Core getCore() {
		return this.core;
	}

	public void setCore(Core core) throws CoreException {
		FractalHelper.getFractalHelper().addComponent(core.getComponent(), this.getComponent(), null);
		this.core = core;
	}

	public ClientEndpoint createClientEndpoint(String name)
			throws CoreException {
		ClientEndpoint clientEndpoint = null;
		Component fractalClientEndpoint = null;
		try {
			//		create a new client endpoint
			fractalClientEndpoint = FractalHelper.getFractalHelper().createNewComponent(ClientEndpointImpl.class.getName(), null);
			FractalHelper.getFractalHelper().addComponent(fractalClientEndpoint, this.getComponent(), null);
			clientEndpoint = (ClientEndpoint) fractalClientEndpoint.getFcInterface("/content");
			FractalHelper.getFractalHelper().startComponent(fractalClientEndpoint);
			
			((ClientEndpointImpl)clientEndpoint).init(fractalClientEndpoint);
			((ClientEndpointImpl)clientEndpoint).setName(name);

			clientEndpoint = (ClientEndpoint) fractalClientEndpoint.getFcInterface("service");
			log.fine("Creation of the fractal client endpoint: " + name);
			this.clientEndpoints.add(clientEndpoint);

		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return clientEndpoint;
	}

	public ProviderEndpoint createProviderEndpoint(String name, Class<? extends Service> serviceClass)
			throws CoreException {
		ProviderEndpoint providerEndpoint = null;
		Component fractalProviderEndpoint = null;
		try {
			// create a new provider endpoint
			fractalProviderEndpoint = FractalHelper.getFractalHelper().createNewComponent(ProviderEndpointImpl.class.getName(), null);
			FractalHelper.getFractalHelper().addComponent(fractalProviderEndpoint, this.getComponent(), null);
			providerEndpoint = (ProviderEndpoint) fractalProviderEndpoint.getFcInterface("/content");
			FractalHelper.getFractalHelper().startComponent(fractalProviderEndpoint);
			
			((ProviderEndpointImpl)providerEndpoint).init(fractalProviderEndpoint);
			((ProviderEndpointImpl)providerEndpoint).setName(name);

			providerEndpoint = (ProviderEndpoint) fractalProviderEndpoint.getFcInterface("service");
			
			Constructor<? extends Service> constructor = (Constructor<? extends Service>) serviceClass.getConstructors()[0];
			Service service = constructor.newInstance(providerEndpoint);
			
			providerEndpoint.setService(service);
			service.setProviderEndpoint(providerEndpoint);
			
			log.fine("Creation of the fractal provider endpoint: " + name);
			this.providerEndpoints.add(providerEndpoint);

		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (IllegalArgumentException e) {
			throw new CoreException(e);
		} catch (InstantiationException e) {
			throw new CoreException(e);
		} catch (IllegalAccessException e) {
			throw new CoreException(e);
		} catch (InvocationTargetException e) {
			throw new CoreException(e);
		}
		return providerEndpoint;
	}

	public List<ClientEndpoint> getClientEndpoints() {
		return this.clientEndpoints;
	}

	public List<ProviderEndpoint> getProviderEndpoints() {
		return this.providerEndpoints;
	}
	
	public void setLog(Logger logger) {
		this.log = logger;
	}
}
