/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.util;


import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import javax.xml.namespace.QName;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import com.ebmwebsourcing.easyviper.environment.test.env.impl.OperationImpl;


public class MockServiceBuilder {

	/**
	 * Build a full <code>Operation</code> object with all information set. If
	 * there is no response set, the operation is "InOnly"; InOut otherwise.
	 *
	 * @param namespace
	 *            the namespace of the interface. used as ns for all operation
	 *            parameters
	 * @param operationName
	 *            the operation name
	 * @param serviceName
	 *            the service name
	 * @param endpointName
	 *            the endpoint name
	 * @param requestXmlFile
	 *            file containing the attempted request
	 * @param requestMessageName
	 *            request message name
	 * @param responseXmlFile
	 *            file containing the response to return may be null if no
	 *            response is returned
	 * @param responseMessageName
	 *            response message name may be null if no response is returned
	 * @param faultXmlFile
	 *            file containing the fault to return may be null if no response
	 *            is returned
	 * @param faultMessageName
	 *            fault message name may be null if no response is returned
	 * @return the corresponding operation
	 * @throws IOException
	 * @throws JDOMException
	 */

	public static Operation buildOperation(
			String operationName, Service service,
			File requestXmlFile, String requestMessageName,
			File responseXmlFile, String responseMessageName,
			File faultXmlFile, String faultMessageName, Class<? extends ExternalMessage> clazz) throws 
			CoreException {

		Operation operation = new OperationImpl(
				operationName,
				(responseXmlFile == null ? Operation.IN_ONLY : Operation.IN_OUT), service);
		ExternalMessage in = buildMessage(service.getName(), service.getProviderEndpoint().getName(), requestXmlFile, requestMessageName, clazz);

		ExternalMessage out = null;
		if (responseXmlFile != null) {
			out = buildMessage(service.getName(), service.getProviderEndpoint().getName(),
					responseXmlFile, responseMessageName, clazz);

		}

		ExternalMessage fault = null;
		if (faultXmlFile != null) {
			fault = buildMessage(service.getName(), service.getProviderEndpoint().getName(),
					faultXmlFile, faultMessageName, clazz);

		}
		operation.addMessageExchangeInstances(in, out, fault);
		return operation;
	}
	
	public static void addMessageExchangeInstances2Operation(Operation op,
			File requestXmlFile, String requestMessageName,
			File responseXmlFile, String responseMessageName,
			File faultXmlFile, String faultMessageName, Class<? extends ExternalMessage> clazz) throws 
			CoreException {


		ExternalMessage in = buildMessage(op.getService().getName(), op.getService().getProviderEndpoint().getName(), requestXmlFile, requestMessageName, clazz);

		ExternalMessage out = null;
		if (responseXmlFile != null) {
			out = buildMessage(op.getService().getName(), op.getService().getProviderEndpoint().getName(),
					responseXmlFile, responseMessageName, clazz);

		}

		ExternalMessage fault = null;
		if (faultXmlFile != null) {
			fault = buildMessage(op.getService().getName(), op.getService().getProviderEndpoint().getName(),
					faultXmlFile, faultMessageName, clazz);

		}
		op.addMessageExchangeInstances(in, out, fault);
	}

	/**
	 * @param namespace
	 *            the namespace of the interface
	 * @param serviceName
	 * @param endpointName
	 * @param xmlFile
	 * @param messageName
	 * @return
	 * @throws CoreException 
	 * @throws JDOMException
	 * @throws IOException
	 */
	public static ExternalMessage buildMessage(QName serviceName, String endpointName, File xmlFile,
			String messageName, Class<? extends ExternalMessage> clazz) throws CoreException  {
		ExternalMessage msg = null;

		try {
			final Constructor c = clazz.getConstructors()[0];
			msg = (ExternalMessage) c.newInstance();


			// FIXME setService = itf or srv name ?
			msg.setService(serviceName);
			msg.setEndpoint(endpointName);
			msg.setQName(new QName(serviceName.getNamespaceURI(), messageName));


			msg.setContent(buildContent(xmlFile));
		} catch (JDOMException e) {
			throw new CoreException(e);
		} catch (IOException e) {
			throw new CoreException(e);
		} catch (final IllegalArgumentException e) {
			throw new CoreException(e);
		} catch (final InstantiationException e) {
			throw new CoreException(e);
		} catch (final IllegalAccessException e) {
			throw new CoreException(e);
		} catch (final InvocationTargetException e) {
			throw new CoreException(e);
		}
		return msg;
	}

	/**
	 * Return a jdom Element corresponding to the root element of the Xml given
	 * file
	 *
	 * @param xmlFile
	 * @return
	 * @throws IOException
	 * @throws JDOMException
	 */
	public static Element buildContent(File xmlFile) throws JDOMException,
	IOException {
		SAXBuilder parser = new SAXBuilder();
		Document doc = parser.build(xmlFile);
		return doc.getRootElement();

	}
}
