/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Operation;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceImpl
implements Service {
    private static Logger log = Logger.getLogger(AbstractServiceImpl.class.getName());
    private QName name;
    private ProviderEndpoint providerEndpoint;
    private List<Operation> operations = new ArrayList<Operation>();

    public AbstractServiceImpl(ProviderEndpoint providerEndpoint) {
        this.providerEndpoint = providerEndpoint;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public void setName(QName qName) {
        this.name = qName;
    }

    @Override
    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public ExternalMessage execute(ExternalMessage externalMessage, String string) throws CoreException {
        ExternalMessage externalMessage2 = null;
        Operation operation = null;
        System.out.println("invokedOperation = " + string);
        for (Operation operation2 : this.operations) {
            System.out.println("operation = " + operation2.getName());
            if (!string.equals(operation2.getName())) continue;
            operation = operation2;
        }
        if (operation == null) {
            log.severe("operation " + string + " with message " + externalMessage.getContent() + " not found on service " + this.getName());
            throw new RuntimeException("operation " + string + " with message:\n " + externalMessage + "\n not found on service " + this.getName());
        }
        log.finest("Execution of operation " + operation.getName() + " on service " + this.getName());
        externalMessage2 = operation.execute(externalMessage);
        return externalMessage2;
    }

    @Override
    public ProviderEndpoint getProviderEndpoint() {
        return this.providerEndpoint;
    }

    @Override
    public void setProviderEndpoint(ProviderEndpoint providerEndpoint) {
        this.providerEndpoint = providerEndpoint;
    }
}

