/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.util;

import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;

public class ThreadClient extends Thread {

	private ClientEndpoint client;

	private ExternalMessage message;
	
	private ExternalMessage response;
	
	private boolean finished = false;

	public ThreadClient(ClientEndpoint client, ExternalMessage message) {
		this.client = client;
		this.message = message;
	}

	@Override
	public void run() {
		try {
			response = client.sendSync(message);
			this.finished = true;
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			this.finished = true;
		} 

	}

	public ExternalMessage getResponse() {
		return response;
	}

	public void setResponse(ExternalMessage response) {
		this.response = response;
	}

	public boolean isFinished() {
		return finished;
	}

	public void setFinished(boolean finished) {
		this.finished = finished;
	}

	public ClientEndpoint getClient() {
		return client;
	}

}
