/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.env;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;

/**
 * This abstract class defines a factory API that enables applications to obtain
 * a BPELFactory capable of producing new Definitions, new WSDLReaders, and new
 * WSDLWriters.
 *
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 *
 * @author Nicolas Salatge - eBM WebSourcing
 */
public abstract class ExecutionEnvironmentTestFactory {
	
	public static String DEFAULT_NAME = "ExecutionEnvironment";


    public static ExecutionEnvironmentTestFactory newInstance() throws CoreException {
        return new ExecutionEnvironmentTestFactoryImpl();
    }


    /**
     * Create the registry of process.
     * @throws BPELException
     */
    public abstract ExecutionEnvironmentTest newEnvironment(String name, boolean explorer) throws CoreException;


}
