/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */
package com.ebmwebsourcing.easyviper.environment.test.env;

import java.util.List;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.env.AbstractSenderImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value = Sender.class, names = "service")
@PolicySets("frascati:scaEasyPrimitive")
public class TestSenderImpl extends AbstractSenderImpl implements Sender {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger
	.getLogger(TestSenderImpl.class.getName());

	private static int internalClientCpt = 1;

	public ExecutionEnvironmentTest getExecutionEnvironmentTest()
	throws CoreException {
		ExecutionEnvironmentTest res = null;
		try {
			Component externalEnvComp = SCAHelper.getSCAHelper()
			.getParent(this.getComponent());
			Component core = SCAHelper.getSCAHelper().getParent(
					externalEnvComp);
			Component executionEnvironment = SCAHelper.getSCAHelper()
			.getParent(core);

			res = (ExecutionEnvironmentTest) executionEnvironment
			.getFcInterface("service");
		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return res;
	}

	@SuppressWarnings("unchecked")
	public void sendTo(InternalMessage<?> internalMessage,
			Endpoint providerEndpoint, ExternalContext context)
	throws CoreException {
		if (internalMessage == null) {
			throw new CoreException(
					"ASynchronous send: Message send to "
					+ providerEndpoint.getEndpointName()
					+ " on operation "
					+ providerEndpoint.getInvokedOperation()
					+ " cannot be null. You must assign the variable associated to this message");
		}
		ExternalMessage<?> externalMessage = this.messageConverter
		.createExternalMessageFromInternalMessage(internalMessage);
		System.out
		.println("MESSAGE SENDED BY CORE to provider "
				+ providerEndpoint.getEndpointName() + ": \n"
				+ externalMessage);

		System.out.println("********* providerEndpoint.getEndpointName() = "
				+ providerEndpoint.getEndpointName());
		System.out.println("********* providerEndpoint.getInterfaceName() = "
				+ providerEndpoint.getInterfaceName());
		System.out.println("********* providerEndpoint.getServiceName() = "
				+ providerEndpoint.getServiceName());

		if (providerEndpoint.getEndpointName() == null) {
			throw new CoreException("the provider endpoint name cannot be null");
		}

		System.out.println("context : " + context);

		System.out.println("provider serviceName : "
				+ providerEndpoint.getServiceName());
		
		System.out.println("provider endpointName : "
				+ providerEndpoint.getEndpointName());
		System.out.println("provider opertation"
				+ providerEndpoint.getInvokedOperation());

		assert context != null;

		/*
		 * TODO need to be improved. The information used in a real
		 * environment is the BPEL partner. As this is not defined here we
		 * assume that if there is a process found for the message, it is
		 * dedicated to a BPEL reply.
		 */
		
	
		ProcessKey pk = new ProcessKeyImpl(null,
				providerEndpoint.getServiceName(),
				providerEndpoint.getEndpointName());
		List<Process> processes = this.getExternalEnvironment().getEngine()
		.getProcessInstanceRegistry().getProcessInstances(pk);

		if (processes.size() > 0) {

			findAndSendResponseToClient(externalMessage, context);

		} else {
			findAndExecuteProvider(externalMessage, providerEndpoint);
		}

	}

	@SuppressWarnings("unchecked")
	public InternalMessage<?> sendSyncTo(InternalMessage<?> message,
			Endpoint providerEndpoint, ExternalContext context)
			throws CoreException {
		if (message == null) {
			throw new CoreException(
					"Synchronous send: Message send to "
					+ providerEndpoint.getEndpointName()
					+ " on operation "
					+ providerEndpoint.getInvokedOperation()
					+ " cannot be null. You must assign the variable associated to this message");
		}
		System.out.println("RRRRRRRRRRRRRRR message.getQName() = "
				+ message.getQName());

		ExternalMessage<?> externalMessage = this.messageConverter
		.createExternalMessageFromInternalMessage(message);
		System.out
		.println("MESSAGE SENDED SYNC BY CORE to provider "
				+ providerEndpoint.getEndpointName() + ": \n"
				+ externalMessage);

		System.out.println("********* providerEndpoint.getEndpointName() = "
				+ providerEndpoint.getEndpointName());
		System.out.println("********* providerEndpoint.getInterfaceName() = "
				+ providerEndpoint.getInterfaceName());
		System.out.println("********* providerEndpoint.getServiceName() = "
				+ providerEndpoint.getServiceName());
		System.out.println("********* providerEndpoint.getAddress() = "
				+ providerEndpoint.getAddress());

		ExternalMessage<?> responseMessage = findAndExecuteProvider(
				externalMessage, providerEndpoint);
		InternalMessage<?> internalMessage = this.messageConverter
		.createInternalMessageFromExternalMessage(responseMessage);

		return internalMessage;
	}

	@SuppressWarnings("unchecked")
	private ExternalMessage findAndExecuteProvider(
			ExternalMessage<?> externalMessage, Endpoint providerEndpoint)// ,
	// ExternalContext
	// context)
	throws CoreException {
		ExternalMessage responseIfExist = null;
		try {
			// Find provider endpoint
			ProviderEndpoint provider = null;
			System.out.println("providerEndpoint.getEndpointName() = "
					+ providerEndpoint.getEndpointName());
			System.out.println("providerEndpoint.getAddress() = "
					+ providerEndpoint.getAddress());
			System.out
			.println("this.getExecutionEnvironmentTest().getProviderEndpoints().size() = "
					+ this.getExecutionEnvironmentTest()
					.getProviderEndpoints().size());
			System.out
			.println("this.getExecutionEnvironmentTest().getProviderEndpoints() = "
					+ this.getExecutionEnvironmentTest()
					.getProviderEndpoints());

			// 1st possiblity everything is known from start in WSDL
			for (ProviderEndpoint providerItem : this.getExecutionEnvironmentTest()
					.getProviderEndpoints()) {
				System.out.println("************** providerItem = "
						+ providerItem.getName());
				if (providerEndpoint.getEndpointName() != null
						&& providerEndpoint.getEndpointName().equals(
								providerItem.getName())) {
					provider = providerItem;
					break;
				}
			}

			// 2nd case, address was set dynamically in BPEL
			if ((provider == null) && (providerEndpoint.getAddress() != null)) {
				// No external endpoint defined but it is a dynamic invocation on
				// unknown endpoint
				// JUST FOR TEST: So, the end of http address must finish by an
				// known endpoint
				for (ProviderEndpoint providerItem : this
						.getExecutionEnvironmentTest().getProviderEndpoints()) {
					System.out.println("************** providerItem = "
							+ providerItem.getName());
					if (providerEndpoint.getAddress() != null
							&& providerEndpoint.getAddress().endsWith(
									providerItem.getName())) {
						provider = providerItem;
						break;
					}
				}
			}

			// 3rd possibility, we know only endpoint interface. We let the external
			// environment find an appropriate
			// endpoint.
			if (provider == null && (providerEndpoint.getInterfaceName() != null)) {
				for (ProviderEndpoint providerItem : this
						.getExecutionEnvironmentTest().getProviderEndpoints()) {
					System.out.println("************** providerItem = "
							+ providerItem.getName());
					if (providerEndpoint.getInterfaceName() != null
							&& providerEndpoint.getInterfaceName().equals(
									providerItem.getMockService()
									.getInterfaceName())) {
						provider = providerItem;
						break;
					}
				}
			}

			System.out.println("PROCESS DEFINITION provider == " + provider);
			ProcessDefinition processDefinition = null;
			if (provider == null) {
				// Not external endpoint: Find if BPEL endpoint
				ProcessKey key = new ProcessKeyImpl(
						providerEndpoint.getInterfaceName(),
						providerEndpoint.getServiceName(),
						providerEndpoint.getEndpointName());
				processDefinition = (ProcessDefinition) this
				.getExecutionEnvironmentTest().getCore().getModel()
				.getRegistry().getProcessDefinition(key);
				System.out.println("processDefinition1 == " + processDefinition);
				if (processDefinition == null) {
					key = new ProcessKeyImpl(providerEndpoint.getInterfaceName(),
							providerEndpoint.getServiceName(),
							providerEndpoint.getAddress());
					processDefinition = (ProcessDefinition) this
					.getExecutionEnvironmentTest().getCore().getModel()
					.getRegistry().getProcessDefinition(key);
				}
				System.out.println("processDefinition2 == " + processDefinition);

				if (processDefinition != null) {
					// send message on a receiver of core
					externalMessage.setEndpoint(providerEndpoint.getEndpointName());
					externalMessage.setService(providerEndpoint.getServiceName());
					externalMessage.setOperationName(providerEndpoint
							.getInvokedOperation());
					System.out
					.println("RRRRRRRRRRRRRRRRRRR externalMessage.getQName() = "
							+ externalMessage.getQName());

					// // create internalClient
					ClientEndpoint internalClient = this
					.getExecutionEnvironmentTest().createClientEndpoint(
							"internalClient"
							+ TestSenderImpl.internalClientCpt);
					TestSenderImpl.internalClientCpt++;
					log.finest("Internal client created:  "
							+ internalClient.getName());
					System.out.println("Internal client created:  "
							+ internalClient.getName());
					responseIfExist = internalClient.sendSync(externalMessage);
					System.out.println("MESSAGE RECEIVED BY CORE from "
							+ internalClient.getName() + " : \n" + responseIfExist);
					log.finest("MESSAGE RECEIVED BY CORE from "
							+ internalClient.getName() + " : \n" + responseIfExist);
					System.out.println("avant supression");
					this.getExecutionEnvironmentTest().getClientEndpoints()
					.remove(internalClient);
					SCAHelper.getSCAHelper().deleteComponent(
							internalClient.getComponent());
					System.out.println("apres supression");

				} else {
					log.severe("Impossible to find provider corresponding to this message: "
							+ externalMessage);
					throw new CoreException(
							"Impossible to find provider corresponding to this message: "
							+ externalMessage);
				}
			} else {
				// Execute provider
				try {
					responseIfExist = provider.accept(externalMessage,
							providerEndpoint.getInvokedOperation());
					if (responseIfExist != null) {
						System.out.println("MESSAGE RECEIVED BY CORE from "
								+ providerEndpoint.getEndpointName() + " : \n"
								+ responseIfExist);
					}
				} catch (CoreException e) {

					InternalMessage mess = this.messageConverter
					.createInternalMessageFromExternalMessage((ExternalMessage) ((CoreException) e)
							.getFault());
					((CoreException) e).setFault(mess);
					throw e;
				}
			}
		} catch(SCAException e) {
			throw new CoreException(e);
		}
		return responseIfExist;
	}

	private void findAndSendResponseToClient(
			ExternalMessage<?> externalMessage, ExternalContext context)
	throws CoreException {
		String clientName = ((TestExternalContextImpl) context)
		.getClientEndpointName();

		for (ClientEndpoint clientItem : this.getExecutionEnvironmentTest()
				.getClientEndpoints()) {
			String name = clientItem.getName();

			if (clientName.equalsIgnoreCase(name)) {
				clientItem.setResponse(externalMessage);
				break;
			}

		}
	}

	private void findAndSendExceptionToClient(CoreException e,
			ExternalContext context) throws CoreException {

		String clientName = ((TestExternalContextImpl) context)
		.getClientEndpointName();
		for (ClientEndpoint clientItem : this.getExecutionEnvironmentTest()
				.getClientEndpoints()) {
			String name = clientItem.getName();
			if (clientName.equalsIgnoreCase(name)) {
				clientItem.setException((CoreException) e);
				break;
			}
		}
	}

	public void sendTo(CoreException e, ExternalContext context)
	throws CoreException {
		this.findAndSendExceptionToClient(e, context);
	}

}
