/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Endpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=Endpoint.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public abstract class AbstractEndpointImpl extends SCAComponentImpl implements Endpoint {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(AbstractEndpointImpl.class.getName());
		
	/**
	 * Default constructor
	 * @throws CoreException
	 */
	public AbstractEndpointImpl()  {
		super();
	}

	public ExecutionEnvironmentTest getExecutionEnvironmentTest() throws CoreException {
		ExecutionEnvironmentTest res = null;
		try {
			Component execEnvComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
			res = (ExecutionEnvironmentTest) execEnvComp.getFcInterface("service");
		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return res;
	}
}
