/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.environment.test.env.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.Service;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=ExecutionEnvironmentTest.class,names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class ExecutionEnvironmentTestImpl extends SCAComponentImpl implements ExecutionEnvironmentTest {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ExecutionEnvironmentTestImpl.class.getName());

	private Core core;

	private List<ClientEndpoint> clientEndpoints = new ArrayList<ClientEndpoint>();

	private List<ProviderEndpoint> providerEndpoints = new ArrayList<ProviderEndpoint>();

	/**
	 * Default constructor
	 * @throws CoreException
	 */
	public ExecutionEnvironmentTestImpl()  {
		super();
	}


	public void addClientEndpoint(ClientEndpoint cep) throws CoreException {
		try {
			SCAHelper.getSCAHelper().addComponent(cep.getComponent(), this.getComponent(), null);
			this.clientEndpoints.add(cep);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
	}

	public void addProviderEndpoint(ProviderEndpoint pep) throws CoreException {
		try {
			SCAHelper.getSCAHelper().addComponent(pep.getComponent(), this.getComponent(), null);
			this.providerEndpoints.add(pep);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
	}

	public Core getCore() {
		return this.core;
	}

	public void setCore(Core core) throws CoreException {
		try {
			SCAHelper.getSCAHelper().addComponent(core.getComponent(), this.getComponent(), null);
			this.core = core;
		} catch (SCAException e) {
			throw new CoreException(e);
		}
	}

	public ClientEndpoint createClientEndpoint(String name)
	throws CoreException {
		ClientEndpoint clientEndpoint = null;
		Component fractalClientEndpoint = null;
		try {
			//		create a new client endpoint
			fractalClientEndpoint = SCAHelper.getSCAHelper().createNewComponent(ClientEndpointImpl.class.getName(), null);
			SCAHelper.getSCAHelper().addComponent(fractalClientEndpoint, this.getComponent(), null);
			clientEndpoint = (ClientEndpoint)((SCAContentController)fractalClientEndpoint.getFcInterface("/sca-content-controller")).getFcContent();
			//fractalClientEndpoint.getFcInterface("/content");
			SCAHelper.getSCAHelper().startComponent(fractalClientEndpoint);

			//((ClientEndpointImpl)clientEndpoint).init(fractalClientEndpoint);
			((ClientEndpointImpl)clientEndpoint).setName(name);

			clientEndpoint = (ClientEndpoint) ((SCAContentController)fractalClientEndpoint.getFcInterface("/sca-content-controller")). getFcContent(); 
			//fractalClientEndpoint.getFcInterface("service");
			log.fine("Creation of the fractal client endpoint: " + name);
			this.clientEndpoints.add(clientEndpoint);

		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (ContentInstantiationException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return clientEndpoint;
	}

	public ProviderEndpoint createProviderEndpoint(String name, Class<? extends Service> serviceClass)
	throws CoreException {
		ProviderEndpoint providerEndpoint = null;
		Component fractalProviderEndpoint = null;
		try {
			// create a new provider endpoint
			fractalProviderEndpoint = SCAHelper.getSCAHelper().createNewComponent(ProviderEndpointImpl.class.getName(), null);
			SCAHelper.getSCAHelper().addComponent(fractalProviderEndpoint, this.getComponent(), null);
			providerEndpoint = (ProviderEndpoint) ((SCAContentController)fractalProviderEndpoint.getFcInterface("/sca-content-controller")).getFcContent();
			//fractalProviderEndpoint.getFcInterface("/content");
			SCAHelper.getSCAHelper().startComponent(fractalProviderEndpoint);

			//			((ProviderEndpointImpl)providerEndpoint).init(fractalProviderEndpoint);
			((ProviderEndpointImpl)providerEndpoint).setName(name);

			//providerEndpoint = (ProviderEndpoint) fractalProviderEndpoint.getFcInterface("service");

			Constructor<? extends Service> constructor = (Constructor<? extends Service>) serviceClass.getConstructors()[0];
			Service service = constructor.newInstance(providerEndpoint);

			providerEndpoint.setMockService(service);
			service.setProviderEndpoint(providerEndpoint);

			log.fine("Creation of the fractal provider endpoint: " + name);
			this.providerEndpoints.add(providerEndpoint);

		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (IllegalArgumentException e) {
			throw new CoreException(e);
		} catch (InstantiationException e) {
			throw new CoreException(e);
		} catch (IllegalAccessException e) {
			throw new CoreException(e);
		} catch (InvocationTargetException e) {
			throw new CoreException(e);
		} catch (ContentInstantiationException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return providerEndpoint;
	}


	public ProviderEndpoint createProviderEndpoint(String name, Class<? extends Service> serviceClass,
			List<org.jdom.Element> payloads)
	throws CoreException {
		ProviderEndpoint providerEndpoint = null;
		Component fractalProviderEndpoint = null;
		try {
			// create a new provider endpoint
			fractalProviderEndpoint = SCAHelper.getSCAHelper().createNewComponent(ProviderEndpointImpl.class.getName(), null);
			SCAHelper.getSCAHelper().addComponent(fractalProviderEndpoint, this.getComponent(), null);
			providerEndpoint = (ProviderEndpoint) ((SCAContentController)fractalProviderEndpoint.getFcInterface("/sca-content-controller")).getFcContent();
			//fractalProviderEndpoint.getFcInterface("/content");
			SCAHelper.getSCAHelper().startComponent(fractalProviderEndpoint);

			//((ProviderEndpointImpl)providerEndpoint).init(fractalProviderEndpoint);
			((ProviderEndpointImpl)providerEndpoint).setName(name);

			//providerEndpoint = (ProviderEndpoint) fractalProviderEndpoint.getFcInterface("service");

			Constructor<? extends Service> constructor = (Constructor<? extends Service>) serviceClass.getConstructors()[0];
			Service service = constructor.newInstance(providerEndpoint, payloads);

			providerEndpoint.setMockService(service);
			service.setProviderEndpoint(providerEndpoint);


			log.fine("Creation of the fractal provider endpoint: " + name);
			this.providerEndpoints.add(providerEndpoint);

		} catch (NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (IllegalArgumentException e) {
			throw new CoreException(e);
		} catch (InstantiationException e) {
			throw new CoreException(e);
		} catch (IllegalAccessException e) {
			throw new CoreException(e);
		} catch (InvocationTargetException e) {
			throw new CoreException(e);
		} catch (ContentInstantiationException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return providerEndpoint;
	}


	public List<ClientEndpoint> getClientEndpoints() {
		return this.clientEndpoints;
	}

	public List<ProviderEndpoint> getProviderEndpoints() {
		return this.providerEndpoints;
	}

	public void setLog(Logger logger) {
		this.log = logger;
	}
}
