/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.autotrash.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.extended.service.autotrash.api.AutoTrashProcessService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class AutoTrashProcessServiceImpl
extends AbstractServiceImpl
implements AutoTrashProcessService {
    private static final int NUMBER_OF_CLEAN_BEFORE_DELETING = 2;
    private Logger log = Logger.getLogger(AutoTrashProcessServiceImpl.class.getName());
    private final List<TrashProcessInstance> list = Collections.synchronizedList(new ArrayList());

    public AutoTrashProcessServiceImpl(Engine engine) {
        super(engine);
    }

    public void run() {
        try {
            this.tryToEndAllProcessIntances();
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.severe("Error in auto trash service: " + exception.getMessage());
        }
    }

    @Override
    public void tryToEndAllProcessIntances() {
        ArrayList<TrashProcessInstance> arrayList = new ArrayList<TrashProcessInstance>();
        arrayList.addAll(this.list);
        this.list.clear();
        for (TrashProcessInstance trashProcessInstance : arrayList) {
            try {
                if (trashProcessInstance.getNumberOfClean() == 2) {
                    this.log.warning("try to delete instance: " + trashProcessInstance.getProcessInstance().getName());
                    SCAHelper.getSCAHelper().stopComponent(trashProcessInstance.getProcessInstance().getComponent());
                    SCAHelper.getSCAHelper().deleteComponent(trashProcessInstance.getProcessInstance().getComponent());
                    continue;
                }
                this.log.warning("try to clean instance: " + trashProcessInstance.getProcessInstance().getName());
                trashProcessInstance.getProcessInstance().end(true);
                List list = trashProcessInstance.getProcessInstance().getProcessKeys();
                for (ProcessKey processKey : list) {
                    ArrayList<Process> arrayList2 = (ArrayList<Process>)this.getEngine().getProcessInstanceRegistry().getMap().get(processKey);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<Process>();
                    }
                    arrayList2.add(trashProcessInstance.getProcessInstance());
                    this.getEngine().getProcessInstanceRegistry().getMap().put(processKey, arrayList2);
                }
            }
            catch (CoreException coreException) {
                trashProcessInstance.setNumberOfClean(trashProcessInstance.getNumberOfClean() + 1);
                this.log.warning("impossible to ended this instance: " + trashProcessInstance.getProcessInstance().getName());
                this.list.add(trashProcessInstance);
            }
            catch (SCAException sCAException) {
                trashProcessInstance.setNumberOfClean(trashProcessInstance.getNumberOfClean() + 1);
                this.log.warning("impossible to ended this instance: " + trashProcessInstance.getProcessInstance().getName());
                this.list.add(trashProcessInstance);
            }
        }
    }

    @Override
    public void addUninstableProcessInstance(Process process) {
        if (process.getState().equals((Object)Process.State.PROCESS_UNSTABLE)) {
            this.list.add(new TrashProcessInstance(process));
        }
    }

    private class TrashProcessInstance {
        private int numberOfClean = 0;
        private Process processInstance = null;

        public TrashProcessInstance(Process process) {
            this.processInstance = process;
        }

        public int getNumberOfClean() {
            return this.numberOfClean;
        }

        public void setNumberOfClean(int n) {
            this.numberOfClean = n;
        }

        public Process getProcessInstance() {
            return this.processInstance;
        }
    }
}

