/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader;

import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarLoader
extends URLClassLoader {
    private List<Class<?>> classList = new ArrayList();
    private Map<String, List<String>> resources = new HashMap<String, List<String>>();
    private Logger log = Logger.getLogger(JarLoader.class.getCanonicalName());

    public JarLoader(URL uRL, ClassLoader classLoader) throws JarException {
        this(uRL, JarLoader.getAllUrlsInManifest(uRL), classLoader);
    }

    private JarLoader(URL uRL, URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
        this.load(uRL);
    }

    private static URL[] getAllUrlsInManifest(URL uRL) throws JarException {
        Object object;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (uRL != null) {
            try {
                File file;
                object = null;
                try {
                    file = new File(uRL.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(uRL.getPath());
                }
                JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
                object = jarInputStream.getManifest();
                if (object != null) {
                    Attributes attributes = ((Manifest)object).getMainAttributes();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    if (attributes != null && attributes.getValue("Class-Path") != null) {
                        StringTokenizer object2 = new StringTokenizer(attributes.getValue("Class-Path"), " ");
                        while (object2.hasMoreElements()) {
                            arrayList2.add(String.valueOf(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separatorChar) + 1)) + object2.nextToken());
                        }
                    }
                    arrayList2.add(0, file.toString());
                    new ArrayList();
                    for (String string : arrayList2) {
                        arrayList.add(0, new File(string).toURL());
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JarException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new JarException(iOException);
            }
        }
        object = new URL[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    public List<Class<?>> getClassList() {
        return this.classList;
    }

    public Map<String, List<String>> getResources() {
        return this.resources;
    }

    /*
     * Unable to fully structure code
     */
    private void load(URL var1_1) {
        try {
            var2_2 = null;
            try {
                var3_5 = new File(var1_1.toURI());
            }
            catch (URISyntaxException v0) {
                var3_5 = new File(var1_1.getPath());
            }
            var4_6 = new JarInputStream(new FileInputStream(var3_5));
            var5_7 = new ZipFile(var3_5);
            var6_8 = var5_7.entries();
            var8_9 = new Hashtable<String, Integer>();
            while (var6_8.hasMoreElements()) {
                var7_10 = var6_8.nextElement();
                var9_11 = var7_10.getName();
                var8_9.put(var9_11.replace("\\", "/"), (int)var7_10.getSize());
            }
            var5_7.close();
            new ArrayList<E>();
            var9_11 = new Hashtable<K, V>();
            var10_12 = null;
            while ((var10_12 = var4_6.getNextJarEntry()) != null) {
                var11_13 = var10_12.getName().replace("\\", "/");
                var12_14 = (Integer)var8_9.get(var11_13);
                var13_15 = new byte[var12_14];
                var14_16 = 0;
                if (var2_2 == null && var11_13.equals("META-INF/MANIFEST.MF")) {
                    var2_2 = new Manifest();
                    while (var14_16 != var12_14) {
                        var15_17 = var4_6.read(var13_15, var14_16, var12_14 - var14_16);
                        if (var15_17 <= 0) continue;
                        var14_16 += var15_17;
                    }
                    var2_2.read(new ByteArrayInputStream(var13_15));
                    continue;
                }
                if (var11_13.endsWith(".class")) ** GOTO lbl42
                this.addResources(var11_13);
                continue;
lbl-1000:
                // 1 sources

                {
                    var15_17 = var4_6.read(var13_15, var14_16, var12_14 - var14_16);
                    if (var15_17 <= 0) continue;
                    var14_16 += var15_17;
lbl42:
                    // 3 sources

                    ** while (var14_16 != var12_14)
                }
lbl43:
                // 1 sources

                var9_11.put(var11_13, var13_15);
            }
            var4_6.close();
            this.defineClassList((Hashtable<String, byte[]>)var9_11);
        }
        catch (FileNotFoundException var2_3) {
            var2_3.printStackTrace();
        }
        catch (IOException var2_4) {
            var2_4.printStackTrace();
        }
    }

    private void addResources(String string) {
        String string2;
        if (string.contains(".") && (string2 = string.substring(string.indexOf(".") + 1, string.length())).length() == 3) {
            List<String> list = this.resources.get(string2.toLowerCase());
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(string);
            this.resources.put(string2, list);
        }
    }

    public List<Class<?>> defineClassList(Hashtable<String, byte[]> hashtable) {
        Enumeration<String> enumeration = hashtable.keys();
        Map<String, byte[]> map = new HashMap<String, byte[]>();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            byte[] byArray = hashtable.get(string);
            if (!string.endsWith(".class")) continue;
            String string2 = string.substring(0, string.indexOf(46));
            string2 = string2.replace("/", ".");
            map.put(string2, byArray);
        }
        map = this.classes2reload(map);
        int n = 0;
        while (map.size() > 0 && n < 10) {
            map = this.classes2reload(map);
            ++n;
        }
        return this.getClassList();
    }

    private Map<String, byte[]> classes2reload(Map<String, byte[]> map) {
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        Iterator<Map.Entry<String, byte[]>> iterator = map.entrySet().iterator();
        Class<?> clazz = null;
        while (iterator.hasNext()) {
            Map.Entry<String, byte[]> entry = iterator.next();
            try {
                clazz = this.defineClass(entry.getKey(), entry.getValue(), 0, entry.getValue().length);
            }
            catch (LinkageError linkageError) {
                this.log.warning("Impossible to load: " + linkageError.getMessage());
                hashMap.put(entry.getKey(), entry.getValue());
            }
            if (clazz != null) {
                this.classList.add(clazz);
            }
            clazz = null;
        }
        return hashMap;
    }

    public static Object callMethod(Class<?> clazz, Object object, String string, Object ... objectArray) throws JarException {
        Object object2 = null;
        try {
            Method method = null;
            int n = 0;
            while (n < clazz.getMethods().length) {
                if (clazz.getMethods()[n].getName().equals("setMessage")) {
                    method = clazz.getMethods()[n];
                    break;
                }
                ++n;
            }
            object2 = method.invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JarException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JarException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JarException(invocationTargetException);
        }
        return object2;
    }

    public String toString() {
        String string = "";
        for (Class<?> clazz : this.getClassList()) {
            string = String.valueOf(clazz.getName()) + "\n";
        }
        return string;
    }
}

