
package com.ebmwebsourcing.enforcerrules;

import java.util.ArrayList;
import java.util.List;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;

public class OneAndOnlyOnePluginVersionInEbmWebsourcingPluginManagement extends AbstractRule {

    @SuppressWarnings("unchecked")
    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject) helper.evaluate("${project}");

        if (mavenProject.getOriginalModel().getBuild() == null)
            return;
        PluginManagement buildPluginManagement = mavenProject.getOriginalModel().getBuild()
                .getPluginManagement();

        if (buildPluginManagement == null)
            return;

        if (isEbmWebsourcingProject(mavenProject)) {
            checkPluginManagementInRootPom(helper, buildPluginManagement);
            for (Profile profile : (List<Profile>) mavenProject.getOriginalModel().getProfiles()) {
                checkPluginManagementInRootPom(helper, profile.getBuild().getPluginManagement());
            }
        } else {
            checkPluginManagementInOtherPom(helper, buildPluginManagement);
            for (Profile profile : (List<Profile>) mavenProject.getOriginalModel().getProfiles()) {
                BuildBase build = profile.getBuild();
                if (build != null) {
                    checkPluginManagementInOtherPom(helper, build.getPluginManagement());
                }
            }
        }
    }

    @SuppressWarnings("unchecked")
    private void checkPluginManagementInOtherPom(EnforcerRuleHelper helper,
            PluginManagement pluginManagement) throws EnforcerRuleException {
        if (pluginManagement == null)
            return;
        List<Plugin> guiltyPlugins = new ArrayList<Plugin>();
        List<Plugin> plugins = pluginManagement.getPlugins();
        for (Plugin plugin : plugins) {
            if (plugin.getVersion() != null) {
                guiltyPlugins.add(plugin);
            }
        }

        if (guiltyPlugins.isEmpty())
            return;

        StringBuffer message = new StringBuffer(
                "Only the pluginManagement section of the global parent project "
                        + "is allowed to define versions for plugins ; following plugins break the rule :\n");
        for (Plugin plugin : guiltyPlugins) {
            message.append("  * ").append(plugin.getArtifactId() + ":" + plugin.getVersion())
                    .append("\n");
        }

        throw new EnforcerRuleException(message.toString());
    }

    @SuppressWarnings("unchecked")
    private void checkPluginManagementInRootPom(EnforcerRuleHelper helper,
            PluginManagement pluginManagement) throws EnforcerRuleException {
        if (pluginManagement == null)
            return;
        List<Plugin> guiltyPlugins = new ArrayList<Plugin>();
        List<Plugin> plugins = pluginManagement.getPlugins();
        for (Plugin plugin : plugins) {
            if (plugin.getVersion() == null) {
                guiltyPlugins.add(plugin);
            }
        }

        if (guiltyPlugins.isEmpty())
            return;

        StringBuffer message = new StringBuffer(
                "Plugin must have versions if defined in root POM pluginManagement section ; following plugins break the rule :\n");
        for (Plugin plugin : guiltyPlugins) {
            message.append("  * ").append(plugin.getArtifactId()).append("\n");
        }

        throw new EnforcerRuleException(message.toString());
    }

}
