/**
 *
 */

package com.ebmwebsourcing.enforcerrules;

import java.util.List;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;

/**
 * @author ofabre
 * 
 */
public class OnlyInternalSnapshotRepoIsAllowed extends AbstractRule {

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {

        List<?> repositories = (List<?>) helper.evaluate("${project.repositories}");
        if (repositories != null) {
            for (Object repo : repositories) {
                RepositoryPolicy snapshotsPolicy = ((Repository) repo).getSnapshots();
                if (snapshotsPolicy != null) {
                    if (snapshotsPolicy.isEnabled()) {
                        // special check for artifactory ; we do assume that libs-snapshots Artifactory virtual repository
			// only contains snapshots produced by petalslink. 
			if (PETALSLINK_ARTIFACTORY_SNAPSHOT_REPO.equals(((Repository) repo).getUrl())) continue;

                        if (!PETALSLINK_SNAPSHOT_REPO.equals(((Repository) repo).getUrl())) {
                            throw new EnforcerRuleException(
                                    "Snapshot repository '"
                                            + ((Repository) repo).getName()
                                            + "' is not allowed as snapshot dependencies source. Only our internal snapshot repository is allowed: "
                                            + PETALSLINK_SNAPSHOT_REPO);
                        }
                    }
                } else {
                    throw new EnforcerRuleException("Project repository '"
                            + ((Repository) repo).getName() + "' must define a snapshots policy.");
                }
            }
        }

    }

}
