
package com.ebmwebsourcing.enforcerrules;

import java.io.File;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

public class ProjectDirectoryMustBeEqualToProjectName extends AbstractRule {

    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        String projectName = (String) helper.evaluate("${project.name}");
        File projectBasedir = (File) helper.evaluate("${project.basedir}");

        if (!projectBasedir.getName().equals(projectName)) {
            throw new EnforcerRuleException("Project directory must be called as project name.");
        }
    }
}
