
package com.ebmwebsourcing.enforcerrules;

import java.util.List;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

public class RootBuilderProjectNameMustEndWithRootBuilder extends AbstractRule {

    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        List<?> modules = (List<?>) helper.evaluate("${project.modules}");
        if (!modules.isEmpty()) {
            String projectName = (String) helper.evaluate("${project.name}");
            if (!projectName.endsWith("-rootbuilder")) {
                throw new EnforcerRuleException(
                        "Root builder project name must end with '-rootbuilder'.");
            }
        }
    }
}
