/**
 *
 */

package com.ebmwebsourcing.enforcerrules;

import java.io.File;

import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

/**
 * @author ofabre
 *
 */
public class ShowProjectInfo extends AbstractRule {

    private static final String PROJECT_INFO_PREFIX = "Extracted project info : ";

    private static final String PROJECT_INFO_SEPARATOR = "@";

    private static final String PROJECT_COORD_SEPARATOR = ":";

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {

        String projectName = (String) helper.evaluate("${project.name}");
        String groupId = (String) helper.evaluate("${project.groupId}");
        String artifactId = (String) helper.evaluate("${project.artifactId}");
        String packaging = (String) helper.evaluate("${project.packaging}");
        String version = (String) helper.evaluate("${project.version}");
        File basedir = (File) helper.evaluate("${project.basedir}");
        String shortGroupId = (String) helper.evaluate("${eclipse.shortGroupId}");

        System.out.println(PROJECT_INFO_PREFIX + "(" + projectName + ")" + PROJECT_INFO_SEPARATOR
                + groupId + PROJECT_COORD_SEPARATOR + artifactId + PROJECT_COORD_SEPARATOR
                + packaging + PROJECT_COORD_SEPARATOR + version + PROJECT_INFO_SEPARATOR
                + basedir.getAbsolutePath() + "/pom.xml" + PROJECT_INFO_SEPARATOR + shortGroupId);

    }

}
