
package com.ebmwebsourcing.enforcerrules;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class DependenciesMustConformToInternalRules extends AbstractRule {

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject) helper.evaluate("${project}");
        SvnSection svnSection = guessMavenProjectSvnSection(mavenProject);
        if (svnSection == SvnSection.UNKNOWN) {
            helper.getLog().warn(
                    String.format("No svn section associated with project '%s'.",
                            mavenProject.getName()));
        }

        MavenProject parentProject = mavenProject.getParent();
        if (parentProject != null) {
            SvnSection parentSvnSection = guessMavenProjectSvnSection(parentProject);
            if (parentSvnSection == SvnSection.UNKNOWN) {
                helper.getLog().warn(
                        String.format("No svn section associated with project '%s'.",
                                parentProject.getName()));
            }

            if (!svnSection.canDependOn(parentSvnSection)) {
                throw new EnforcerRuleException(String.format(
                        "A project in '%s' cannot inherit from a project in '%s'.", svnSection,
                        parentSvnSection));
            }
        }

        for (Object o : mavenProject.getDependencies()) {
            Dependency dep = (Dependency) o;
            if (!dep.getGroupId().startsWith("com.ebmwebsourcing.")) {
                continue;
            }
            MavenProject dependencyMavenProject = findMavenProjectForDependency(helper,
                    mavenProject, dep);
            SvnSection dependencySvnSection = guessMavenProjectSvnSection(dependencyMavenProject);
            helper.getLog().info(
                    String.format("'%s', %s [%s] => '%s', %s [%s].", mavenProject.getName(),
                            mavenProject.getScm().getConnection(), svnSection,
                            dependencyMavenProject.getName(), dependencyMavenProject.getScm()
                                    .getConnection(), dependencySvnSection));
            if (dependencySvnSection == SvnSection.UNKNOWN) {
                helper.getLog().warn(
                        String.format("No svn section associated with project '%s'.",
                                dependencyMavenProject.getName()));
            }

            if (!svnSection.canDependOn(dependencySvnSection)) {
                throw new EnforcerRuleException(String.format(
                        "A project in '%s' cannot depend on a project in '%s'.", svnSection,
                        dependencySvnSection));
            }
        }

    }

}
