
package com.ebmwebsourcing.enforcerrules;

import java.util.ArrayList;
import java.util.List;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;

public class ProjectGroupIdEndsWithEclipseShortGroupId extends AbstractRule {

    public void doExecute(EnforcerRuleHelper helper) throws Exception {
        List<String> prefixes = new ArrayList<String>();
    	prefixes.add("com.ebmwebsourcing.");
    	prefixes.add("com.petalslink.");
    	prefixes.add("org.petalslink.");
    	prefixes.add("");
        
    	String eclipseShortGroupId = (String) helper.evaluate("${eclipse.shortGroupId}");
        String groupId = (String) helper.evaluate("${project.groupId}");

        for(String prefix : prefixes){
        	if(groupId.startsWith(prefix)){
                if (!groupId.replaceAll(prefix, "").equals(eclipseShortGroupId)) {
                    throw new EnforcerRuleException(
                            "Project eclipse.shortGroupId must be equal to groupId without '" + prefix + "'.");
                } else {
                	break;
                }
        	}
        }
    }

}
