
package com.ebmwebsourcing.enforcerrules;

import java.util.HashSet;
import java.util.Set;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class ReleasedDependencyRequired extends AbstractRule {
    /**
     * Define all excluded dependency. This feature allows to exclude released
     * version for the check of snapshot.
     */
    private final static Set<Dependency> releasedDependenciesRequired = new HashSet<Dependency>();

    static {
        initExcludedDependencies();
    }

    @Override
    protected void doExecute(EnforcerRuleHelper helper) throws Exception {
        MavenProject mavenProject = (MavenProject) helper.evaluate("${project}");
        // check dependencies
        for (Object o : mavenProject.getDependencies()) {
            Dependency dep = (Dependency) o;
            checkReleasedVersion(dep);
        }
    }

    /**
     * Add released dependency
     */
    private static void initExcludedDependencies() {
    }

    /**
     * Check if the current dependency is excluded from the "snapshot check".
     * 
     * @param dep
     * @return true if this dependency is allowed
     * @throws EnforcerRuleException
     */
    private void checkReleasedVersion(Dependency currentDependency) throws EnforcerRuleException {
        for (Dependency d : releasedDependenciesRequired) {
            if (currentDependency.getArtifactId().equals(d.getArtifactId())
                    && currentDependency.getGroupId().equals(d.getGroupId())) {
                if (!currentDependency.getVersion().equals(d.getVersion())) {
                    throw new EnforcerRuleException(
                            String.format(
                                    "Project depends on %s with version %s but only released dependency with version %s is allowed.",
                                    currentDependency.getArtifactId(),
                                    currentDependency.getVersion(), d.getVersion()));
                }
            }
        }
    }
}
