/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.business.domain.to;



public class Constants {

	
    public interface SynapseEnum {

        /**
         * each constant should have a string description
         */
        public String getDescription();

    

        /**
         * each constant should have a name
         */
        public String getName();
        
        


    }

    
    
   public static enum EventType implements SynapseEnum {
        
        EmptyStart("Empty start", "Empty start","images/icons/Empty_start_event.png"),
        EmptyEnd("Empty end","Empty end","images/icons/Empty_end_event.png"), 
        Message("Message", "Message","images/ico/bpmn/event/start/message.png"), 
        Timer("Timer", "Timer","images/icons/Timer_event.png"), 
        Error("Error", "Error","images/icons/Error_event.png"),
        Rule("Rule", "Rule","images/icons/Rule_event.png"),
        Termination("Termination", "Termination","images/icons/Terminate_event.png"),
        unknown("Unknown","Unknown",null);
        
        private final String description;
        private final String name;
        private final String icon;

        EventType(final String name, final String description,final String icon) {
            
            this.description    = description;
            this.name           = name;
            this.icon           = icon;
        
        }
        


        public String getDescription() {
            return description;
        }
        
        public String getIcon(){
            return icon;
        }
        
        public String getName() {
            return name;
        }

        @Override
        public String toString() {
            return getDescription();
        }
    }
    
    
    
    public static enum BPMNObjectGroup implements SynapseEnum{
        
        Swimlanes("Swimlanes","Swimlanes"),
        Event("Event","Event"),
        Activity("Activity","Activity"),
        Artifact("Artifact","Artifact"),
        Gateway("Gateway","Gateway"),
        Flow("Flow","Flow")
        ;
        
        private String name;
        private String description;
        
        private BPMNObjectGroup(String name,String description){
            
            this.name = name;
            this.description = description;    
            
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }
        
        @Override
        public String toString() {
            return getDescription();
        }
        
    }
    
  
    public static enum DataType implements SynapseEnum {
        String("string", "string"), DateTime("dateTime", "dateTime"), Int("int", "int"), Float("float", "float"), Long("long", "long"), Boolean("boolean", "boolean") ;
        private final String description;
        private final String name;

        DataType(final String name, final String description) {
            this.description = description;
            this.name = name;
        }
        
        

        public String getDescription() {
            return description;
        }

        public String getName() {
            return name;
        }
        
        public static DataType getDataTypeByString(String type){
        	
        	for(DataType d:values()){
        		
        		if (d.name.equals(type)){
        			return d;
        		}
        	
        	}
        	
        	return null;
        
        }
        
    }  
    
    
    
  public static enum BPMNObjectType implements SynapseEnum{
        
        //Containers
        Pool("Pool","Pool","Pool-style",BPMNObjectGroup.Swimlanes),
        Lane("Lane","Lane","Lane-style",BPMNObjectGroup.Swimlanes),
        
        //Activities
        Task("Task","Task","Task-style",BPMNObjectGroup.Activity),
        SubProcess("Sub-Process","Sub-Process","SubProcess-style",BPMNObjectGroup.Activity),
        ActivityLoop("Activity loop","Activity loop","Activity_loop-style",BPMNObjectGroup.Activity), 
        
        //Gateways
        DataBasedInclusiveGateway("Data based inclusive gateway","Data based inclusive gateway","Data_based_inclusive_gateway-style",BPMNObjectGroup.Gateway),
        DataBaseExclusiveGateway("Data based exclusive gateway","Data based exclusive gateway","Data_based_exclusive_gateway-style",BPMNObjectGroup.Gateway),
        ParallelGateway("Parallel gateway","Parallel gateway","Parallel_gateway-style",BPMNObjectGroup.Gateway),
        EventBasedExclusiveGateway("Event based exclusive gateway","Event based exclusive gateway","Event_based_exclusive_gateway-style",BPMNObjectGroup.Gateway),
        
        //Events
        EmptyStartEvent("Empty start event","Empty start event","Start_event-style",BPMNObjectGroup.Event),
        EmptyEndEvent("Empty end event","Empty end event","End_event-style",BPMNObjectGroup.Event),
        MessageEvent("Message event","Message event","Message_event-style",BPMNObjectGroup.Event),
        TimerEvent("Timer event","Timer event","Timer_event-style",BPMNObjectGroup.Event),
        ErrorEvent("Error event","Error event","Error_event-style",BPMNObjectGroup.Event),
        RuleEvent("Rule event","Rule event","Rule_event-style",BPMNObjectGroup.Event),
        TerminationEvent("Terminate event","Terminate event","Terminate_event-style",BPMNObjectGroup.Event), 
        
        //Flows
        SequenceFlow("Sequence Flow","Sequence Flow",null,BPMNObjectGroup.Flow),
        MessageFlow("Message flow","Message Flow",null,BPMNObjectGroup.Flow),
        
        //Others
        DataObject("Data object","Data object",null,BPMNObjectGroup.Artifact)
        ;
        
        private final String description;
        private final String name;
        private final String style;
        private final BPMNObjectGroup group;
        
        private BPMNObjectType(String name,String description,String style,BPMNObjectGroup group) {
            
            this.name           = name;
            this.description    = description;
            this.style          = style;
            this.group          = group;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }
        
        public String getStyle(){
            return this.style;
        }
        
        public BPMNObjectGroup getGroup(){
            return this.group;
        }
        
        @Override
        public String toString() {
            return getDescription();
        }
        
  }
    
  
  
  
  public static enum CPatCategory implements SynapseEnum {
      Business("Business", "Business"), Simple("Simple", "Simple"), Strategic("Strategic", "Strategic"), unknown("Unknown",
      "Unknown");
      private final String description;
      private final String name;

      CPatCategory(final String name, final String description) {
          this.description = description;
          this.name = name;
      }
      

      public String getDescription() {
          return description;
      }

      public String getName() {
          return name;
      }

      @Override
      public String toString() {
          return getDescription();
      }
  }
  
  public static enum VOphase implements SynapseEnum {
      VO_precreation("pre-creation", "pre-creation"), VO_creation("creation", "creation"), VO_operation("operation", "operation"), VO_termination("termination", "termination"), unknown("Unknown",
      "Unknown");
      private final String description;
      private final String name;

      VOphase(final String name, final String description) {
          this.description = description;
          this.name = name;
      }



      
      public String getDescription() {
          return description;
      }

      public String getName() {
          return name;
      }

      @Override
      public String toString() {
          return getDescription();
      }
  }
  
  
  
	
}
