/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.comment;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.FlowNodeElement;
import com.ebmwebsourcing.gwt.raphael.client.core.Rectangle;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementDragListener;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementResizableListener;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.TextArea;

public class CommentElement extends FlowNodeElement implements DiagramElementResizableListener, MouseDownHandler, MouseUpHandler, MouseMoveHandler{

//	private CommentEditWidget editor ;
	private TextArea editor;
	private boolean dndState;
	private int initialX;
	private int initialY;
	public CommentElement(String id, String content, int x, int y) {
		super(new Rectangle(DOM.createUniqueId(), x, y, 80, 50, 0) );
		
		this.isDraggable(true);
		this.isResizable(true); 
		
		editor = new TextArea();
		add(editor,2,2);
		editor.setText(content);
		editor.setStylePrimaryName("borderless");
		
		addResizableListener(this);
		dndState = false;
		
		editor.addMouseDownHandler(this);
		editor.addMouseUpHandler(this);
		editor.addMouseMoveHandler(this);
		
		
	}
	
	
	@Override
	protected void onLoad() {
		// TODO Auto-generated method stub
		super.onLoad();
		editor.setPixelSize(getOffsetWidth()-4, getOffsetHeight()-4);
		getSvgElement().attr("stroke-width", "0");
	}
	
	@Override
	public void setLabel(String label) {
		editor.setText(label);
	}

	public void onResize() {
		editor.setPixelSize(getOffsetWidth()-4, getOffsetHeight()-4);
	}

	public void onStart() {
		editor.setPixelSize(getOffsetWidth()-4, getOffsetHeight()-4);
	}

	public void onStop() {
		editor.setPixelSize(getOffsetWidth()-4, getOffsetHeight()-4);
	}


	/* ********** Here is the trick to get dnd working :) ******/
	public void onMouseDown(MouseDownEvent arg0) {
		// enter dnd
		dndState = true;
		initialX = arg0.getX();
		initialY = arg0.getY();

		fireOnDragStart();
	}


	public void onMouseUp(MouseUpEvent arg0) {
		dndState = false;
		
		fireOnDragStop();
		
	}


	public void onMouseMove(MouseMoveEvent arg0) {
		if(dndState){
			// smooth dnd
			setX(arg0.getRelativeX(getDiagramPanel().getElement())-initialX);
			setY(arg0.getRelativeY(getDiagramPanel().getElement())-initialY);
		}
		
		// reimpl the dnd notification ;)
		fireOnDrag();
		
		
	}

	
}
