/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.swimlane;


import java.util.ArrayList;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.activity.TaskType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.data.CollectionDataObjectType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.data.DataInputType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.data.DataObjectType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.data.DataOutputType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.end.EndMessageElementType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.end.EndNoneElementType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.intermediate.IntermediateThrowingMessageElementType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.intermediate.IntermediateEmptyElementType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.intermediate.IntermediateCatchingMessageElementType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.start.StartTopLevelConditionalElementType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.start.StartTopLevelMessageElementType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.event.start.StartTopLevelNoneType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.FlowNodeElement;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.HasNameHandlers;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.NameEvent;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic.NameHandler;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.gateway.ExclusiveGatewayType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.gateway.InclusiveGatewayType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.gateway.ParallelGatewayType;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.widget.PopupEditor;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.widget.PopupTextLineEditor;
import com.ebmwebsourcing.gwt.raphael.client.core.Rectangle;
import com.ebmwebsourcing.gwt.raphael.client.core.Text;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.ConnectorExtremityType;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramComplexElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElementChildData;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramGroupElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementMouseListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementResizableListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramGroupElementListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.semantic.Selectable;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PopupPanel.PositionCallback;



/**
 * 
 * @author nfleury
 *
 */
public class LaneElement extends DiagramComplexElement implements Selectable, HasNameHandlers{
	
	private DiagramGroupElement dropZone;
	
	private DiagramComplexElement labelZone;
	private String labelTxt;
	private DiagramElement labelElement;
	private PopupEditor<String> labelEditor;
	
	private PoolElement parentPool;
	
	private ArrayList<FlowNodeElement> flowNodes = new ArrayList<FlowNodeElement>();
	
	private ArrayList<LaneListener> listeners	 = new ArrayList<LaneListener>();
	
	public LaneElement(String id) {
	
		super(new Rectangle(id, 30, 100, 480, 200, 0),new LaneType());
		
		this.dropZone 	= new LaneDropZone(this,new Rectangle(id+"dropZone",0,0,460,200,0));
		//Declare the accepted elements for current lane
		this.dropZone.addAcceptedType(new TaskType());
		this.dropZone.addAcceptedType(new StartTopLevelNoneType());
		this.dropZone.addAcceptedType(new StartTopLevelMessageElementType());
		this.dropZone.addAcceptedType(new StartTopLevelConditionalElementType());
		this.dropZone.addAcceptedType(new IntermediateEmptyElementType());
		this.dropZone.addAcceptedType(new IntermediateCatchingMessageElementType());
		this.dropZone.addAcceptedType(new EndMessageElementType());
		this.dropZone.addAcceptedType(new EndNoneElementType());
		this.dropZone.addAcceptedType(new IntermediateThrowingMessageElementType());
		this.dropZone.addAcceptedType(new ExclusiveGatewayType());
		this.dropZone.addAcceptedType(new InclusiveGatewayType());
		this.dropZone.addAcceptedType(new ParallelGatewayType());
		this.dropZone.addAcceptedType(new DataObjectType());
		this.dropZone.addAcceptedType(new DataOutputType());
		this.dropZone.addAcceptedType(new DataInputType());
		this.dropZone.addAcceptedType(new CollectionDataObjectType());
		
		
		//Lane ignore lane
		this.dropZone.addFilteredElementType(new LaneType());
		this.dropZone.addFilteredElementType(new ConnectorExtremityType());
		
		this.labelZone 	= new DiagramComplexElement(new Rectangle(id+"LaneLabelZone", 0, 0, 20, 200, 0));
		this.labelTxt = "";
		labelElement = new DiagramElement(new Text(id+"label", "", 0, 100));
		labelTxt = "";
		labelZone.addDiagramElement(labelElement, 10, 100, false);
		
		this.isResizable(true);
		
		this.addDiagramElement(labelZone, 0, 0, true);
		this.addDiagramElement(dropZone, 20, 0, true);
		
		this.initListeners();
		
		labelEditor = new PopupTextLineEditor();
		labelEditor.addCloseHandler(new LabelClickHandler());
		addClickHandler(new LabelClickHandler());
		labelZone.addDoubleClickHandler(new LabelClickHandler());
		
   }
	
	
	private void initListeners() {
		
		//Resizable
		
		//When pool size is smaller than current lane size => resize the pool to fit
		this.addResizableListener(new DiagramElementResizableListenerAdapter(){
			
			@Override
			public void onStop() {
			
				getParentPool().resize();
				
			}
			
		});
		

		
		this.dropZone.addListener(new DiagramGroupElementListenerAdapter(){
			@Override
			public void onDiagramElementAdded(DiagramElement diagramElement,int x, int y) {

					
				for(LaneListener listener:listeners){
					listener.onReceiveFlowNode((FlowNodeElement)diagramElement, x, y);
				}
				
				if (diagramElement instanceof FlowNodeElement){
					FlowNodeElement el = (FlowNodeElement) diagramElement;
					el.setParentLane(LaneElement.this);
					if (flowNodes.contains(el)==false){
						flowNodes.add(el);
					}
					
					
					//update child data position
//					DiagramElementChildData cdata  = dropZone.getChildDataForElement(el);
//					assert(cdata!=null);
//					
//					int newX =	el.getAbsoluteLeft() - el.getParentLane().getDropZone().getX();
//					int newY =  el.getAbsoluteTop() - el.getParentLane().getDropZone().getY();
//					
//					cdata.setX(newX);
//					cdata.setY(newY);
					
				}
				
			}
			
			@Override
			public void onDiagramElementRejected(DiagramElement diagramElement) {

				
			}
			
			@Override
			public void onDiagramElementRemoved(DiagramElement diagramElement,int x, int y) {

				for(LaneListener listener:listeners){
					listener.onFlowNodeOut((FlowNodeElement) diagramElement,x,y);
				}
				
				if (diagramElement instanceof FlowNodeElement){
					FlowNodeElement el = (FlowNodeElement) diagramElement;
					
					flowNodes.remove(el);
					
				}				
				
			}
			
		});
		
		
		//TODO:SHOULD'NT BE HERE!!!!!:
		this.setDefaultMouseListener(new DiagramElementMouseListenerAdapter(){
			
			@Override
			public void onMouseDown() {

				LaneElement.this.getParentPool().getDiagramPanel().uniqueElementSelected(LaneElement.this);
			
			}
			
			public void onMouseEnter(){
				
				LaneElement.this.getParentPool().getMouseListeners().remove(LaneElement.this.getParentPool().getDefaultMouseListener());
				
			}
			
			public void onMouseLeave(){
				
				LaneElement.this.getParentPool().getMouseListeners().add(LaneElement.this.getParentPool().getDefaultMouseListener());
			
			}
			
			
		});
		
		
	}
	
	

	public void addFlowNode(final FlowNodeElement child,final int x,final int y){
	

		int absoluteXposition = getX() + x ;
		
		int absoluteYposition = getY() + y ;
		
		LaneElement.this.getDiagramPanel().add(child, absoluteXposition, absoluteYposition);

		child.setParentLane(LaneElement.this);
		
		flowNodes.add(child);
		
		dropZone.addChild(child, x-labelZone.getWidth(), y);


	}
	
	public void removeFlowNode(FlowNodeElement child){
		flowNodes.remove(child);
	}
	
	@Override
	public void setWidth(final int width) {
		super.setWidth(width);
		
//		if (isLoaded) parentPool.resize();
				
	}
	
	@Override
	public void setHeight(int height) {
		super.setHeight(height);
	
//		if (isLoaded) parentPool.resize();

	}
	
	protected void refreshSVGsize() {
		super.refreshSVGsize();
		
		dropZone.setWidth(this.getWidth()-labelZone.getWidth());
		dropZone.setHeight(this.getHeight());
		
		this.labelZone.setHeight(this.getHeight()-1);
		
		
		
		
	}
	
	public void setParentPool(PoolElement parentPool) {
		this.parentPool = parentPool;
	}
	
	public PoolElement getParentPool() {
		return parentPool;
	}
	
	public ArrayList<FlowNodeElement> getFlowNodes() {
		return flowNodes;
	}

	@Override
	protected void onLoad() {		
		super.onLoad();
		
	
		
		this.dropZone.getSvgElement().attr("stroke-width", "2");
//		this.dropZone.getSvgElement().attr("stroke", "green");
		this.labelZone.getSvgElement().attr("stroke-width", "2");
		this.labelZone.getSvgElement().attr("fill", "0-#e1e1e1-#ffffff");
		this.getSvgElement().attr("stroke-width", "2");
		
		
		this.getJqueryObject().css("z-index","5000");
		
		this.getJqueryObject().css("position","relative");
		
		//Label
		this.labelElement.getSvgElement().attr("font-size", "12");
		this.labelElement.getSvgElement().attr("font-weight", "4");
		this.labelElement.getSvgElement().rotate(-90, true);

		



	}



	
	
	public void isDeselected() {

		this.setBorderColor("black");
		for(DiagramElementChildData cdata:this.getDiagramElementChildren()){
			
			cdata.getDiagramElement().setBorderColor("black");
		
		}
		
	}


	public void isSelected() {
	
	this.setBorderColor("red");
		for(DiagramElementChildData cdata:this.getDiagramElementChildren()){
			
			cdata.getDiagramElement().setBorderColor("red");
		}

	}


	public HandlerRegistration addNameHandler(NameHandler handler) {
		return addHandler(handler, NameEvent.getType());
	}
	
	public void setLabel(String label){
		this.labelTxt = label;
		this.labelElement.getSvgElement().attr("text", label);
	}
	
	public String getLabel(){
		return labelTxt;
	}
	
	private void updateName(String newName){
		setLabel(newName);
		NameEvent.fire(this, newName);
	}
	
	
	
	private void showLabelEditor(){
		labelEditor.setValue(getLabel());
		// show label editor in center
		labelEditor.setPopupPositionAndShow(new PositionCallback() {
			
			public void setPosition(int width, int height) {
				
				int xPos = labelElement.getAbsoluteLeft()-width/2;
				int yPos = labelElement.getAbsoluteTop()-height/2;
				labelEditor.setPopupPosition(xPos, yPos);
			}
		});
		labelEditor.focusOn();
	}
	
	//******************************
	// Inner classes
	//******************************
	
	private class LabelClickHandler implements ClickHandler, CloseHandler<PopupPanel>, DoubleClickHandler{

		public void onClick(ClickEvent event) {
			int relativeX = getRelativeX(event.getNativeEvent(),getDiagramPanel().getElement());
			int relativeY = getRelativeY(event.getNativeEvent(), getDiagramPanel().getElement());
			
			int labelX = labelElement.getSvgElement().getX();
			int labelY = labelElement.getSvgElement().getY();
			int labelW = labelElement.getSvgElement().getWidth();
			int labelH = labelElement.getSvgElement().getHeight();
			labelX -= labelH/2;
			labelY -= labelW/2;
			
			boolean xOk = relativeX >= labelX && relativeX <= labelX + labelH;
			boolean yOk = relativeY >= labelY && relativeY <= labelY + labelW;
			if(xOk && yOk){
				showLabelEditor();
			}
		}
	
		

		private int getRelativeX(NativeEvent e, Element target){
			return e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() +
		      target.getOwnerDocument().getScrollLeft();


		}
		
		private int getRelativeY(NativeEvent e, Element target){
			return e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop();
		}

		public void onClose(CloseEvent<PopupPanel> event) {
			updateName(labelEditor.getValue());
		}

		public void onDoubleClick(DoubleClickEvent arg0) {
			// double click on label zone
			showLabelEditor();
		}
		
	}


	public void addListener(LaneListener listener){
		listeners.add(listener);
	}

	public ArrayList<LaneListener> getListeners() {
		return listeners;
	}
	
	
	public DiagramGroupElement getDropZone() {
		return dropZone;
	}
}
