/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.grid;

import java.util.ArrayList;
import java.util.List;

import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.CheckboxColumnConfig;
import com.gwtext.client.widgets.grid.CheckboxSelectionModel;
import com.gwtext.client.widgets.grid.ColumnModel;

public abstract class AbstractCheckBoxGrid<T> extends AbstractGrid<T>{
	
	protected CheckboxSelectionModel cbSelectionModel;
	
	public AbstractCheckBoxGrid() {
		super();
		
	}

	@Override
	protected void buildGrid() {
		super.buildGrid();
		
		this.cbSelectionModel = new CheckboxSelectionModel();
		
		//add checkbox column first
		ArrayList<BaseColumnConfig> updatedColumns = new ArrayList<BaseColumnConfig>();
		
		updatedColumns.add(new CheckboxColumnConfig(cbSelectionModel));
		updatedColumns.addAll(getColumnsConfig());
		
		BaseColumnConfig[] columns 	= updatedColumns.toArray(new BaseColumnConfig[updatedColumns.size()]); 
		
		ColumnModel columnModel 	= new ColumnModel(columns);
		
		gridPanel.setColumnModel(columnModel);
		gridPanel.setSelectionModel(cbSelectionModel);
	
	}
	
	
	public List<T> getSelectedValues(){
		
		Record[] records = cbSelectionModel.getSelections();  
		
		ArrayList<T> selectedValues = new ArrayList<T>();
		
        for (int i = 0; i < records.length; i++) {  
            Record record = records[i];  
        
            selectedValues.add((T) record.getAsObject(OBJECT_REF));
        }
		
		return selectedValues;
	}
	
	
	
}
