/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events;

import com.google.gwt.event.shared.GwtEvent;

public class BeforeEditRecordEvent<T> extends GwtEvent<EditableGridHandler>{
	
	private T record;
	private int rowIndex;
	private int colIndex;

	public static Type<EditableGridHandler> TYPE = new Type<EditableGridHandler>();
	
	public BeforeEditRecordEvent(T record,int rowIndex,int colIndex) {
		this.record 	= record;
		this.rowIndex  	= rowIndex;
		this.colIndex 	= colIndex;
	}
	

	
	public T getRecord() {
		return record;
	}
	
	public int getColIndex() {
		return colIndex;
	}
	
	public int getRowIndex() {
		return rowIndex;
	}


	@Override
	protected void dispatch(EditableGridHandler handler) {
		handler.onBeforeEditorRecord(this);
	}


	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<EditableGridHandler> getAssociatedType() {
		return TYPE;
	}
	
	
	
	
}
