/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.treepanel;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.widgets.ext.api.treepanel.ITreeNode;
import com.ebmwebsourcing.geasytools.widgets.ext.api.treepanel.ITreePanel;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Node;
import com.gwtext.client.widgets.tree.event.TreeNodeListenerAdapter;

public class TreeNode extends com.gwtext.client.widgets.tree.TreeNode implements ITreeNode{
	
	private ITreePanel treePanel;
	private String name;
	private ITreeNode parentNode;
	private HandlerManager handlerManager;
	private List<ITreeNode> children;
	
	public TreeNode() {
		this.handlerManager = new HandlerManager(this);
		this.children = new ArrayList<ITreeNode>();
		
		this.addListener(new TreeNodeListenerAdapter(){
			@Override
			public void onClick(Node node, EventObject e) {
				
				ClickEvent.fireNativeEvent(e.getBrowserEvent(), TreeNode.this);
				
				
			}
		});
		
	}
	
	@Override
	public String getName() {
		return name;
	}

	@Override
	public ITreePanel getTreePanel() {
		return treePanel;
	}

	@Override
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public void setTreePanel(ITreePanel treePanel) {
		this.treePanel = treePanel;
	}

	@Override
	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return handlerManager.addHandler(ClickEvent.getType(), handler);
	}

	@Override
	public void fireEvent(GwtEvent<?> event) {
		handlerManager.fireEvent(event);
	}

	@Override
	public void addNode(ITreeNode node) {
		this.children.add(node);
		this.appendChild((Node) node);
	}

	@Override
	public ITreeNode getParentTreeNode() {
		return parentNode;
	}

	@Override
	public ITreeNode[] getChildren() {
		return children.toArray(new ITreeNode[children.size()]);
	}

	
	
	

}
