/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class MultipleChoiceListUIField<T extends List<E>, E> extends AbstractUIFieldWidget<T>{
	
	private List<E> options;
	private VerticalPanel listPanel;
	
	private List<E> selectedValues;
	private List<CheckBox> checkboxes;
	
	private Label label;
	
	public MultipleChoiceListUIField(T options) {
		
		this.options = (List<E>) options;
		
		this.selectedValues = new ArrayList<E>();
		
		final AbsolutePanel fp = new AbsolutePanel();
		fp.setPixelSize(180, 20);
		
		fp.addStyleName("multilist-element");
		
		this.label = new Label("");
		
		
		fp.add(label);
		
		this.listPanel = new VerticalPanel();
		listPanel.setVisible(false);
		listPanel.addStyleName("multilist-list");
		
		final Timer t = new Timer() {
			
			@Override
			public void run() {
				
				listPanel.setVisible(false);
				
			}
		};		
		
		RootPanel.get().add(listPanel);
		
		MouseOverHandler moh = new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				label.setVisible(false);
				listPanel.setVisible(true);
				listPanel.setWidth(String.valueOf(fp.getOffsetWidth())+"px");

				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					
					@Override
					public void execute() {
						
						RootPanel.get().setWidgetPosition(listPanel, fp.getAbsoluteLeft(), fp.getAbsoluteTop()+fp.getOffsetHeight());
						
					}
				});

				// TODO Auto-generated method stub
			}
		};
		
		fp.addDomHandler(moh, MouseOverEvent.getType());
		
		MouseOutHandler moutH = new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				label.setVisible(true);
				listPanel.setVisible(false);
				
			}
		};
		

		MouseOverHandler listPanelMouseOver = new MouseOverHandler() {
			
			@Override
			public void onMouseOver(MouseOverEvent event) {
				
				t.cancel();
				
			}
		};
		
		listPanel.addDomHandler(listPanelMouseOver, MouseOverEvent.getType());
		
		MouseOutHandler fpMo = new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				
				t.schedule(100);
				
			}
		};
		
		listPanel.addDomHandler(moutH, MouseOutEvent.getType());
		
		fp.addDomHandler(fpMo, MouseOutEvent.getType());
		
		if (options!=null) populate();
		
		initWidget(fp);
		
	}
	
	public void setOptions(List<E> options){
	    this.options = options;
	    populate();
	}
	
	
	private void populate(){
		
		this.checkboxes = new ArrayList<CheckBox>();
		this.listPanel.clear();
		
		for(int i=0;i<options.size();i++){
			
			final E value = options.get(i); 
			
			final CheckBox cb = new CheckBox(value.toString());
			
			this.checkboxes.add(i,cb);
			
			cb.addClickHandler(new ClickHandler() {
				
				@Override
				public void onClick(ClickEvent event) {
					
					if (cb.getValue()==true && selectedValues.contains(value)==false){
							
						selectedValues.add(value);
						setValue((T) selectedValues, true);
						label.setText(selectedValues.toString());
						
					}else if (cb.getValue()==false && selectedValues.contains(value)==true){
						
						selectedValues.remove(value);
						setValue((T) selectedValues, true);
						label.setText(selectedValues.toString());
					}
					
				}
			});
			
			listPanel.add(cb);
			
		}
		
		
	}
	
	
	@Override
	protected Widget getMainWidget() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public T getValue() {
		return (T) selectedValues;
	}
	



	@Override
	public void setValue(T value, boolean fireEvent) {
		
		if (value!=null){
			
			for(int i=0;i<this.options.size();i++){
				
				for(E v:value){
					
					if (v.equals(options.get(i))){
						
						checkboxes.get(i).setValue(true);
						break;
						
					}
					
				}
				
				
			}
		
			label.setText(value.toString());
			
		}
		
		
		if (fireEvent) ValueChangeEvent.fire(MultipleChoiceListUIField.this, getValue());
	}
	
	@Override
	protected boolean autoloadWidget() {
		return false;
	}

}
