/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Widget;

public class UIFieldCheckBox extends AbstractUIFieldWidget<Boolean> {
	
	
	private CheckBox uiCheck;
	
	private Boolean value;
	
	public UIFieldCheckBox(Boolean defaultValue){
		
		this.uiCheck = new CheckBox();
		
		this.uiCheck.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				setValue(uiCheck.getValue(), true);
				
			}
		});
		
		initWidget(uiCheck);
	}
	
	
	@Override
	protected Widget getMainWidget() {
		return uiCheck;
	}

	@Override
	public Boolean getValue() {
		return value;
	}



	@Override
	public void setValue(Boolean value, boolean fireEvent) {
		
		uiCheck.setValue(value);
		
		if (fireEvent) ValueChangeEvent.fire(UIFieldCheckBox.this, value);
	}
	
	@Override
	protected boolean autoloadWidget() {
		return false;
	}

}
