/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.UndoRedoSession;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DumDumModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DummyModel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;

public class UndoRedoSessionTestGwt
extends GWTTestCase {
    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
    }

    public String getModuleName() {
        return "com.ebmwebsourcing.geasytools.modeleditor.modelmanager.ModelManager";
    }

    public void testUndoRedoSession() {
        System.out.println("-----------TESTING UNDO REDO SESSION------------");
        DummyModel model1 = (DummyModel)GWT.create(DummyModel.class);
        DummyModel model2 = (DummyModel)GWT.create(DummyModel.class);
        DummyModel model3 = (DummyModel)GWT.create(DummyModel.class);
        UndoRedoSession urs = new UndoRedoSession();
        urs.registerModel((Object)model1);
        urs.registerModel((Object)model2);
        urs.registerModel((Object)model3);
        System.out.println("=>updating mode1,model2,model3");
        model1.setString1("toto");
        model2.setString1("tutu");
        model3.setString1("bobo");
        System.out.println("model1=>" + model1.getString1());
        System.out.println("model2=>" + model2.getString1());
        System.out.println("model3=>" + model3.getString1());
        System.out.println("=>UNDO");
        urs.undo();
        System.out.println("model1=>" + model1.getString1());
        System.out.println("model2=>" + model2.getString1());
        System.out.println("model3=>" + model3.getString1());
        UndoRedoSessionTestGwt.assertEquals((String)"state0", (String)model3.getString1());
        System.out.println("=>UNDO");
        urs.undo();
        System.out.println("model1=>" + model1.getString1());
        System.out.println("model2=>" + model2.getString1());
        System.out.println("model3=>" + model3.getString1());
        UndoRedoSessionTestGwt.assertEquals((String)"state0", (String)model2.getString1());
        System.out.println("=>UNDO");
        urs.undo();
        System.out.println("model1=>" + model1.getString1());
        System.out.println("model2=>" + model2.getString1());
        System.out.println("model3=>" + model3.getString1());
        UndoRedoSessionTestGwt.assertEquals((String)"state0", (String)model1.getString1());
        System.out.println("=>REDO");
        urs.redo();
        System.out.println("model1=>" + model1.getString1());
        System.out.println("model2=>" + model2.getString1());
        System.out.println("model3=>" + model3.getString1());
        UndoRedoSessionTestGwt.assertEquals((String)"toto", (String)model1.getString1());
        System.out.println("=>REDO");
        urs.redo();
        System.out.println("model1=>" + model1.getString1());
        System.out.println("model2=>" + model2.getString1());
        System.out.println("model3=>" + model3.getString1());
        UndoRedoSessionTestGwt.assertEquals((String)"tutu", (String)model2.getString1());
        System.out.println("=>REDO");
        urs.redo();
        System.out.println("model1=>" + model1.getString1());
        System.out.println("model2=>" + model2.getString1());
        System.out.println("model3=>" + model3.getString1());
        UndoRedoSessionTestGwt.assertEquals((String)"bobo", (String)model3.getString1());
    }

    public void testUndoRedoSessionWithList() {
        System.out.println("------TESTING UNDO REDO WITH LISTS--------");
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        UndoRedoSession ur = new UndoRedoSession();
        ur.registerModel((Object)model);
        System.out.println("Adding 1 element to list");
        model.addDummyModel(new DummyModel());
        UndoRedoSessionTestGwt.assertEquals((int)1, (int)model.getDummyModels().size());
        System.out.println("List size before undo:" + model.getDummyModels().size() + ":" + model.getDummyModels());
        System.out.println("UNDO");
        ur.undo();
        UndoRedoSessionTestGwt.assertEquals((int)0, (int)model.getDummyModels().size());
        System.out.println("List size after undo:" + model.getDummyModels().size() + ":" + model.getDummyModels());
        System.out.println("REDO");
        ur.redo();
        UndoRedoSessionTestGwt.assertEquals((int)1, (int)model.getDummyModels().size());
        System.out.println("List size after redo:" + model.getDummyModels().size() + ":" + model.getDummyModels());
        System.out.println("Adding 1 element to list");
        model.addDummyModel(new DummyModel());
        UndoRedoSessionTestGwt.assertEquals((int)2, (int)model.getDummyModels().size());
        System.out.println("List size before undo:" + model.getDummyModels().size() + ":" + model.getDummyModels());
        System.out.println("UNDO");
        ur.undo();
        UndoRedoSessionTestGwt.assertEquals((int)1, (int)model.getDummyModels().size());
        System.out.println("List size after undo:" + model.getDummyModels().size() + ":" + model.getDummyModels());
        System.out.println("REDO");
        ur.redo();
        System.out.println("List size after redo:" + model.getDummyModels().size() + ":" + model.getDummyModels());
        UndoRedoSessionTestGwt.assertEquals((int)2, (int)model.getDummyModels().size());
        System.out.println("UNDO UNDO");
        ur.undo();
        ur.undo();
        System.out.println("List size after 2 undo:" + model.getDummyModels().size() + ":" + model.getDummyModels());
        UndoRedoSessionTestGwt.assertEquals((int)0, (int)model.getDummyModels().size());
        System.out.println("Adding 1 element to list");
        model.addDummyModel(new DummyModel());
        System.out.println("List size before undo:" + model.getDummyModels().size() + ":" + model.getDummyModels());
        System.out.println("UNDO");
        UndoRedoSessionTestGwt.assertTrue((ur.hasMoreUndo() ? 1 : 0) != 0);
        ur.undo();
        UndoRedoSessionTestGwt.assertEquals((int)0, (int)model.getDummyModels().size());
        UndoRedoSessionTestGwt.assertTrue((!ur.hasMoreUndo() ? 1 : 0) != 0);
        System.out.println("List size after undo:" + model.getDummyModels().size() + ":" + model.getDummyModels());
        ur.undo();
        ur.undo();
        ur.undo();
    }

    public void testUndoThanAddRemovesPreviousEntriesToHistory() {
        System.out.println("----------------UndoThanAddRemovesPreviousEntriesToHistory----------------");
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        UndoRedoSession ur = new UndoRedoSession();
        ur.registerModel((Object)model);
        model.setString1("state1");
        System.out.println("state 1==>" + model.getString1());
        model.setString2("state2");
        System.out.println("state 2==>" + model.getString1());
        ur.undo();
        System.out.println("undo state 2==>" + model.getString1());
        model.setString1("state3");
        System.out.println("state 3==>" + model.getString1());
        ur.undo();
        System.out.println("undo state 3==>" + model.getString1());
        UndoRedoSessionTestGwt.assertEquals((String)"state1", (String)model.getString1());
    }

    public void testHasMoreRedo() {
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        UndoRedoSession ur = new UndoRedoSession();
        ur.registerModel((Object)model);
        UndoRedoSessionTestGwt.assertTrue((!ur.hasMoreRedo() ? 1 : 0) != 0);
        model.setString1("state1");
        UndoRedoSessionTestGwt.assertTrue((!ur.hasMoreRedo() ? 1 : 0) != 0);
        ur.undo();
        UndoRedoSessionTestGwt.assertTrue((ur.hasMoreRedo() ? 1 : 0) != 0);
        ur.redo();
        UndoRedoSessionTestGwt.assertTrue((!ur.hasMoreRedo() ? 1 : 0) != 0);
        model.setString1("state2");
        UndoRedoSessionTestGwt.assertTrue((!ur.hasMoreRedo() ? 1 : 0) != 0);
    }

    public void testHasMoreUndo() {
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        UndoRedoSession ur = new UndoRedoSession();
        ur.registerModel((Object)model);
        UndoRedoSessionTestGwt.assertTrue((!ur.hasMoreUndo() ? 1 : 0) != 0);
        model.setString1("state1");
        UndoRedoSessionTestGwt.assertTrue((ur.hasMoreUndo() ? 1 : 0) != 0);
        ur.undo();
        UndoRedoSessionTestGwt.assertTrue((!ur.hasMoreUndo() ? 1 : 0) != 0);
        model.setString1("state2");
        UndoRedoSessionTestGwt.assertTrue((ur.hasMoreUndo() ? 1 : 0) != 0);
    }
}

