/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.MethodObserver;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ModelManagerFactory;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DummyModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.AbstractUITemplate;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.EnclosedFieldMappingPolicy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IInstantiationHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.UIBindingManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test.SpecializedTemplate;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.test.SpecializedTextBoxUIField;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.TextBoxUIField;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;

public class UIBinderTestGwt
extends GWTTestCase {
    private ModelManagerFactory<DummyModel> modelManagerFactory;

    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
        this.modelManagerFactory = new ModelManagerFactory();
    }

    public String getModuleName() {
        return "com.ebmwebsourcing.geasytools.modeleditor.modelmanager.ModelManager";
    }

    public void testSimpleUIBinding() {
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        VerticalPanel form = (VerticalPanel)this.modelManagerFactory.getUIBindingManager().bind((Object)model, (AbstractUITemplate)new SpecializedTemplate());
        TextBoxUIField textBox = (TextBoxUIField)form.getWidget(0);
        System.out.println("Model initial value:" + model.getString1());
        System.out.println("textBoxValue: " + (String)textBox.getValue());
        UIBinderTestGwt.assertEquals((String)model.getString1(), (String)((String)textBox.getValue()));
        System.out.println("Changing model 1 string1 to: hello");
        model.setString1("hello");
        System.out.println("textBoxValue: " + (String)textBox.getValue());
        UIBinderTestGwt.assertEquals((String)model.getString1(), (String)((String)textBox.getValue()));
        System.out.println("Changing textBox value to: goodbye");
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox, (Object)"goodbye");
        System.out.println("model string 1 value:" + model.getString1());
        UIBinderTestGwt.assertEquals((String)((String)textBox.getValue()), (String)model.getString1());
    }

    public void testTwoModelsWithSpecificMappingPolicy() {
        DummyModel model1 = (DummyModel)GWT.create(DummyModel.class);
        DummyModel model2 = (DummyModel)GWT.create(DummyModel.class);
        EnclosedFieldMappingPolicy efmp = new EnclosedFieldMappingPolicy(DummyModel.class, "string1", (IInstantiationHandler)new IInstantiationHandler<SpecializedTextBoxUIField>(){

            public SpecializedTextBoxUIField instantiate() {
                return new SpecializedTextBoxUIField();
            }
        });
        UIBindingManager.getInstance().addClassMappingPolicy(efmp);
        VerticalPanel form1 = (VerticalPanel)this.modelManagerFactory.getUIBindingManager().bind((Object)model1, (AbstractUITemplate)new SpecializedTemplate());
        Widget textBox1 = form1.getWidget(0);
        UIBinderTestGwt.assertTrue((boolean)(textBox1 instanceof SpecializedTextBoxUIField));
        SpecializedTextBoxUIField stb1 = (SpecializedTextBoxUIField)textBox1;
        ValueChangeEvent.fire((HasValueChangeHandlers)stb1, (Object)"hello");
        UIBinderTestGwt.assertEquals((String)"hello", (String)model1.getString1());
        UIBinderTestGwt.assertEquals((String)"state0", (String)model2.getString1());
        VerticalPanel form2 = (VerticalPanel)this.modelManagerFactory.getUIBindingManager().bind((Object)model2, (AbstractUITemplate)new SpecializedTemplate());
        SpecializedTextBoxUIField textBox2 = (SpecializedTextBoxUIField)form2.getWidget(0);
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox2, (Object)"hello2");
        UIBinderTestGwt.assertEquals((String)"hello", (String)model1.getString1());
        UIBinderTestGwt.assertEquals((String)"hello2", (String)model2.getString1());
    }

    public void testTowModelsWithDefaultMappingPolicy() {
        DummyModel model1 = (DummyModel)GWT.create(DummyModel.class);
        DummyModel model2 = (DummyModel)GWT.create(DummyModel.class);
        VerticalPanel form1 = (VerticalPanel)this.modelManagerFactory.getUIBindingManager().bind((Object)model1, (AbstractUITemplate)new SpecializedTemplate());
        TextBoxUIField textBox1 = (TextBoxUIField)form1.getWidget(0);
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox1, (Object)"hello");
        UIBinderTestGwt.assertEquals((String)"hello", (String)model1.getString1());
        UIBinderTestGwt.assertEquals((String)"state0", (String)model2.getString1());
        VerticalPanel form2 = (VerticalPanel)this.modelManagerFactory.getUIBindingManager().bind((Object)model2, (AbstractUITemplate)new SpecializedTemplate());
        TextBoxUIField textBox2 = (TextBoxUIField)form2.getWidget(0);
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox2, (Object)"hello2");
        UIBinderTestGwt.assertEquals((String)"hello", (String)model1.getString1());
        UIBinderTestGwt.assertEquals((String)"hello2", (String)model2.getString1());
    }

    public void testSimpleUIBindingWithObserverManager() {
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        VerticalPanel form = (VerticalPanel)this.modelManagerFactory.getUIBindingManager().bind((Object)model, (AbstractUITemplate)new SpecializedTemplate());
        TextBoxUIField textBox = (TextBoxUIField)form.getWidget(0);
        this.modelManagerFactory.getObserverManager().addMethodObserver((Object)model, (MethodObserver)new MethodObserver<DummyModel>(){

            public void afterMethodCalled(DummyModel model, Object ... parameters) {
                System.out.println("method Called with value:" + parameters[0]);
            }

            public void beforeMethodCalled(DummyModel model, Object ... parameters) {
            }
        });
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox, (Object)"hello1");
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox, (Object)"hello2");
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox, (Object)"hello3");
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox, (Object)"hello4");
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox, (Object)"hello5");
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox, (Object)"hello6");
    }

    public void testBindSameModelMultipleTimes() {
        DummyModel model = (DummyModel)GWT.create(DummyModel.class);
        final ArrayList values = new ArrayList();
        VerticalPanel form = (VerticalPanel)this.modelManagerFactory.getUIBindingManager().bind((Object)model, (AbstractUITemplate)new SpecializedTemplate());
        TextBoxUIField textBox = (TextBoxUIField)form.getWidget(0);
        this.modelManagerFactory.getObserverManager().addMethodObserver((Object)model, (MethodObserver)new MethodObserver<DummyModel>(){

            public void afterMethodCalled(DummyModel model, Object ... parameters) {
                System.out.println("method Called with value:" + parameters[0]);
                values.add((String)parameters[0]);
            }

            public void beforeMethodCalled(DummyModel model, Object ... parameters) {
            }
        });
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox, (Object)"value1");
        UIBinderTestGwt.assertEquals((int)1, (int)values.size());
        UIBinderTestGwt.assertEquals((String)"value1", (String)((String)values.get(0)));
        values.clear();
        VerticalPanel form2 = (VerticalPanel)this.modelManagerFactory.getUIBindingManager().bind((Object)model, (AbstractUITemplate)new SpecializedTemplate());
        TextBoxUIField textBox2 = (TextBoxUIField)form2.getWidget(0);
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox2, (Object)"value2");
        UIBinderTestGwt.assertEquals((int)1, (int)values.size());
        UIBinderTestGwt.assertEquals((String)"value2", (String)((String)values.get(0)));
        values.clear();
        VerticalPanel form3 = (VerticalPanel)this.modelManagerFactory.getUIBindingManager().bind((Object)model, (AbstractUITemplate)new SpecializedTemplate());
        TextBoxUIField textBox3 = (TextBoxUIField)form3.getWidget(0);
        ValueChangeEvent.fire((HasValueChangeHandlers)textBox3, (Object)"value3");
        UIBinderTestGwt.assertEquals((int)1, (int)values.size());
        UIBinderTestGwt.assertEquals((String)"value3", (String)((String)values.get(0)));
        values.clear();
    }
}

