/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelscope;

import java.util.LinkedHashSet;
import java.util.Set;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IHasModelBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IWatchedModelProxy;

public class ModelScopeHelper {

	public static void assignChildren(IHasScope parentModel,IHasScope...children){
		
		if (parentModel instanceof IHasScopeProxy){
			
			IHasScopeProxy parentPoxy = (IHasScopeProxy) parentModel;
			
			for(IHasScope child:children){
				
				if (child instanceof IHasScopeProxy){
					
					parentPoxy.addChild(child);
					
				}
				
			}
		
		}
		
	}
	
	
	public static Object getBindedModel(IHasScope model){
		
		if (model instanceof IHasModelBinder){
			
			if (model instanceof IWatchedModelProxy<?>){
				
				IWatchedModelProxy<?> proxy = (IWatchedModelProxy<?>) model;
				
				return proxy.getBindedModel();
				
			}
			
		}
		
		return null;
	}
	
	public static Set<IHasScope> getChildren(IHasScope element){
		
		LinkedHashSet<IHasScope> result = new LinkedHashSet<IHasScope>();
		
		if (element instanceof IHasScopeProxy){
			
			IHasScopeProxy proxy = (IHasScopeProxy) element;
			
			return proxy.getChildren();
		}
		
		
		return result;
	}
	
	
	public static Class<? extends IHasScope> getRealType(IHasScope model){
		
		if (model instanceof IHasScopeProxy){
			
			IHasScopeProxy proxy = (IHasScopeProxy) model;
			
			return proxy.getRealType();
		}
		
		
		return null;
	}
	
	public static void assignScope(String scopeId,IHasScope... models){
		
		for(IHasScope model:models){
			
			if (model instanceof IHasScopeProxy){
				
				IHasScopeProxy proxy = (IHasScopeProxy) model;
				
				proxy.attachToScope(scopeId);
			}
			
		}
		
	}
	
	
}
