/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelscope;

import java.util.LinkedHashSet;

public abstract class ScopeResolver<T> {
	
	private String scopeId;
	protected T mainModel;
	
	public ScopeResolver(String scopeId) {
			
		this.scopeId = scopeId;
		
	}
	
	public ScopeResolver(){
		
	}
	
	
	public ScopeResolver(String scopeId,T mainModel) {
		this(scopeId);
		this.mainModel = mainModel;
	}
	
	public void setScopeId(String scopeId) {
		this.scopeId = scopeId;
	}
	
	protected <E> LinkedHashSet<E> getInstances(Class<? extends E> type){
		
		LinkedHashSet<E> result = new LinkedHashSet<E>();
		
		LinkedHashSet<IHasScope> candidates = ScopeRegistry.getInstance().getModelsByScope(scopeId);
		
		for(IHasScope candidate : candidates){
			
			if (candidate.getClass()==ModelScopeHelper.getRealType(candidate)){
				result.add((E) candidate);
				continue;
			}
			
			//try to get binded model if actual model has binder
			Object bindedModel = ModelScopeHelper.getBindedModel(candidate);
			
			if (bindedModel!=null){
				
				if (bindedModel.getClass()==type){
					result.add((E) bindedModel);
				}
				
			}
			
		}
		
		return result;
	}
	
	protected <E> E getInstance(Class<? extends E> type){
		return getInstances(type).iterator().next();
	}
	
	protected <E> LinkedHashSet<E> getInstanceChildren(Object instance,Class<? extends E> childrenType){
		
		LinkedHashSet<E> result = new LinkedHashSet<E>();
		
		//case 1 => instance type = IHasScope => search directly in children
		if (instance instanceof IHasScope){
			
			for(IHasScope child:ModelScopeHelper.getChildren((IHasScope) instance)){
			
				if (ModelScopeHelper.getRealType(child)==childrenType){
					
					result.add((E) child);
					
				}
				
			}
		
		}else{
		//case 2 => instance type <> IHasScope => search in every candidates the IHasModel where bindedModel = instance
			//then iterate through its chidren
			
			
			LinkedHashSet<IHasScope> candidates = ScopeRegistry.getInstance().getModelsByScope(scopeId);
			
			IHasScope winner = null;
			
			for(IHasScope candidate:candidates){
				
				Object bindedModel = ModelScopeHelper.getBindedModel(candidate);
				
				if (bindedModel==instance){
					
					winner = candidate;
					
					break;
				}
				
			}
			
			if (winner!=null){
				
				for(IHasScope child:ModelScopeHelper.getChildren((IHasScope) winner)){
					
					Object bindedModel = ModelScopeHelper.getBindedModel(child);
					
					if (bindedModel.getClass()==childrenType){
						
						result.add((E) bindedModel);
						
					}
					
				}			
			
				
			}
		
		}
			

		return result;
	}
	
	
	
	public abstract T resolve();
	
	
}
