/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field;
import com.google.gwt.event.shared.GwtEvent;

public class SetterCalledEvent extends GwtEvent<IObservableHandler> implements ISetterCalledEvent{
	
	public static Type<IObservableHandler> TYPE = new Type<IObservableHandler>();
	
	private String methodName;
	
	private Field field;
	
	public SetterCalledEvent(String methodName,Field field) {
		
		this.methodName = methodName;
		this.field		= field;
	}
	
	@Override
	protected void dispatch(IObservableHandler handler) {
		handler.onSetterCalled(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IObservableHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public Field getField() {
		return field;
	}

	@Override
	public String getMethodName() {
		return methodName;
	}

}
