/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection;

import com.google.gwt.event.shared.GwtEvent;

public class SetFieldValueCalledEvent extends GwtEvent<IHasReflectionHandler> implements ISetFieldValueCalledEvent{
	
	public static Type<IHasReflectionHandler> TYPE = new Type<IHasReflectionHandler>();
	
	private String fieldName;
	private Object value;
	
	public SetFieldValueCalledEvent(String fieldName,Object value) {
		
		this.fieldName = fieldName;
		this.value 	   = value;
		
	}
	
	@Override
	protected void dispatch(IHasReflectionHandler handler) {
		handler.onSetFieldValueCalled(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IHasReflectionHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public String getFieldName() {
		return fieldName;
	}

	@Override
	public Object getValue() {
		return value;
	}



}
