/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder;

public class Field {

	private String name;
	private Class<?> type;
	private Class<?> enclosingType;
	private Object value;
	private Object enclosingObject;
	
	private SetterHandler setterHandler;
	
	public Field(String name,Class<?> type,Class<?> enclosingType) {
		this.name = name;
		this.type = type;
		this.enclosingType = enclosingType;
	}
	
	public String getName() {
		return name;
	}
	
	public Class<?> getType() {
		return type;
	}
	
	public Class<?> getEnclosingType() {
		return enclosingType;
	}
	
	public void setFieldValue(Object value){
		this.value = value;
	}
	
	public void setValue(Object value) {
		this.setterHandler.setValue(value);
	}
	
	public Object getValue() {
		return value;
	}
	
	public void setSetterHandler(SetterHandler setterHandler) {
		this.setterHandler = setterHandler;
	}
	
	public Object getEnclosingObject() {
		return enclosingObject;
	}
	
	public void setEnclosingObject(Object enclosingObject) {
		this.enclosingObject = enclosingObject;
	}
	
	@Override
	public boolean equals(Object obj) {
		
		Field compareMe = (Field) obj;
		
		if (this.enclosingType.toString().equals(compareMe.getEnclosingType().toString())  && compareMe.getName().equals(this.getName())){
			
			return true;
			
		}
		
		return false;
	}
	
	@Override
	public int hashCode() {
		return this.enclosingType.toString().hashCode()+this.name.hashCode();
	}
	
}
