/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield;


import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.UIFieldWidget;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.BeforeDisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.DisplayEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield.events.IUIFieldHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractUIFieldWidget<T> extends Composite implements UIFieldWidget<T>{
	
	private Object dataProvider;
	private HandlerManager handlerManager;
	
	public AbstractUIFieldWidget() {
		
		if (autoloadWidget()) initWidget(getMainWidget());
		this.handlerManager = new HandlerManager(this);
	}
	
	@Override
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}
	
	@Override
	public Object getDataProvider() {
		return dataProvider;
	}
	
	@Override
	public void setDataProvider(Object dataProvider) {
		this.dataProvider = dataProvider;
	}
	
	protected abstract Widget getMainWidget();


	@Override
	public HandlerRegistration addValueChangeHandler(
			ValueChangeHandler<T> handler) {
		return handlerManager.addHandler(ValueChangeEvent.getType(), handler);
	}
	
	protected boolean autoloadWidget(){
		return true;
	}
	
	
	public void addUIFieldHandler(IUIFieldHandler handler){
		handlerManager.addHandler(BeforeDisplayEvent.Type, handler);
		handlerManager.addHandler(DisplayEvent.Type, handler);
	}
	
	@Override
	protected void onAttach() {
		super.onAttach();
		handlerManager.fireEvent(new BeforeDisplayEvent());
		handlerManager.fireEvent(new DisplayEvent());
	}
	
	
	
}
