/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.uifield;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;

import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public class TextBoxUIField<T> extends AbstractUIFieldWidget<T> {

	private Field field;
	private boolean hasObservable=false;
	
	private TextBox textbox;
	
	public TextBoxUIField() {
		super();
		
	}
	
	
	public void setValue(T value,boolean fireEvent){
		
		if (value==null){
			textbox.setValue("");
		}else{
			textbox.setValue(String.valueOf(value));			
		}

	}




	
	

	@Override
	protected Widget getMainWidget() {
		
		if (this.textbox==null){
			this.textbox = new TextBox();
			
			this.textbox.addValueChangeHandler(new ValueChangeHandler<String>() {
				
				@Override
				public void onValueChange(ValueChangeEvent<String> event) {
					TextBoxUIField.this.fireEvent(event);
				}
			});
			
		}
		
		return textbox;
	}


	@Override
	public T getValue() {
		return (T) textbox.getValue();
	}



	
	
	

}
