/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;

import java.util.HashSet;
import java.util.Set;

public class Annotation {

	private String name;
	private Set<String> parameters;
	
	
	public Annotation(String name) {
		this.name = name;
		this.parameters = new HashSet<String>();
	}
	
	public void addParameter(String param){
		this.parameters.add(param);
	}
	
	public String getName() {
		return name;
	}
	
	private String getParameters(){
		if (parameters.size()==0) return "";
		return parameters.toString().replace("[", "").replace("]", "");
	}
	
	@Override
	public String toString() {
		
		StringBuilder sb = new StringBuilder();
		
		sb.append("@"+name);
		
		if (parameters.size()>0){
			sb.append("(");
			sb.append(getParameters());
			sb.append(")");
		}
		
		return sb.toString();
	}
	
}
