/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;

public class Body{
	
	private StringBuilder builder;
	
	public Body(String content) {
		this.builder = new  StringBuilder(content);
	}
	
	public Body() {
		this("");
	}
	
	public void instantiate(Field field,String...params){

		StringBuilder sb = new StringBuilder();
		
		int max = params.length;
		int cur = 1;
		
		for(String param:params){
			
			sb.append(param);
			
			if (cur<max){
				sb.append(",");
			}
			
			cur++;
		}
		
		this.append("this."+field.getName()+" = new "+field.getType().getCanonicalName()+"("+sb.toString()+")");
		
	}
	
	public void clear(){
		this.builder.delete(0, builder.length());
	}
	
	public void instantiate(Class<?> type,String varName,String...params){
		
		StringBuilder sb = new StringBuilder();
		
		int max = params.length;
		int cur = 1;
		
		for(String param:params){
			
			sb.append(param);
			
			if (cur<max){
				sb.append(",");
			}
			
			cur++;
		}
		
		this.append(type.getCanonicalName()+" "+varName+"= new "+type.getCanonicalName()+"("+sb.toString()+")");
	
	}
	
	public void append(String content){
		assert(content!=null);
		if (content.equals("")==false) builder.append(content+";\n");
	}
	
	public void prepend(String content){
		assert(content!=null);
		if (content.equals("")==false) builder.insert(0, content+";\n");
	}
	
	@Override
	public String toString() {
		return builder.toString();
	}
}