/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClassTypeHelper {

	private Class<?> clazz;
	
	public ClassTypeHelper(Class<?> clazz) {
		this.clazz = clazz;
	}
	
	
	public Set<Field> getAllFields(){
		
		LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
		
		Class<?> currentType = clazz;
		
		while(currentType.getSuperclass()!=null){
			System.out.println("current type:"+currentType.getCanonicalName());
			for(Field field:currentType.getFields()){
				System.out.println("field===>"+field.getName());
				if (fieldsContain(field, fields)==false) fields.add(field);
			}
			
			currentType = currentType.getSuperclass();
			
		}
		
		return fields;
	}
	
	private boolean fieldsContain(Field field,Set<Field> fields){
		
		for(Field f:fields){
			
			if (field.getName().equals(f.getName())){
				return true;
			}
			
		}
		
		return false;
	}
	
}
