/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.Utils;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JType;

public class Field {

	private Visibility visibility;
	private String name;
	private Class<?> type;
	private JParameterizedType parametizedType;
	private JType jtype;
	
	public Field(Visibility visibility,Class<?> type,String name) {
		
		this.visibility = visibility;
		this.type 		= type;
		this.name 		= name;

	
	}
	
	public Field(Visibility visibility,Class<?> type,String name,JParameterizedType parametizedType) {
		this(visibility,type,name);
		this.parametizedType  = parametizedType;	
	}
	
	public JParameterizedType getParametizedType() {
		return parametizedType;
	}
	
	public void setJtype(JType jtype) {
		this.jtype = jtype;
	}
	
	public Visibility getVisibility() {
		return visibility;
	}

	public String getName() {
		return name;
	}

	public Class<?> getType() {
		return type;
	}
	
	
	public Method getGetter(boolean isOverride){
		
		boolean isBoolean = (type==Boolean.class || type==boolean.class);
		
		Method getter = new Method(Visibility.PUBLIC, type, Utils.getGetterMethodByFieldName(name, isBoolean));
		getter.setJtype(jtype);
		
		getter.isOverride(isOverride);
		
		if (suffix==null){
			getter.getBody().append("return this."+name);
		}else{
			getter.getBody().append("return this."+name+suffix);	
		}
		
		
		return getter;
	}
	
	public Method getGetter(boolean isOverride,String nameSuffix){
		this.suffix = nameSuffix;
		return getGetter(isOverride);
	} 
	
	public Method getSetter(boolean isOverride,boolean callSuper){
		
		Method setter = new Method(Visibility.PUBLIC, void.class, Utils.getSetterMethodByFieldName(name));
		setter.isOverride(isOverride);
		
		if (parametizedType==null){
			if (jtype==null){
				setter.addParameter(setter.new Parameter(type, name));
			}else{
				setter.addParameter(setter.new Parameter(jtype, name));				
			}
			
		}else{
			
			if (jtype==null){
				setter.addParameter(setter.new Parameter(type, name,parametizedType.getTypeArgs()));	
			}else{
				setter.addParameter(setter.new Parameter(jtype, name,parametizedType.getTypeArgs()));
			}
		}
		
		if (callSuper==false){
			if (suffix==null){
				setter.getBody().append("this."+name+"="+name);
			}else{
				setter.getBody().append("this."+name+suffix+"="+name);
			}
		}else{
			if (suffix==null){
				setter.getBody().append("super."+Utils.getSetterMethodByFieldName(name)+"("+name+")");
			}else{
				setter.getBody().append("super."+Utils.getSetterMethodByFieldName(name)+"("+name+suffix+")");
			}
		}
		
		return setter;
	}
	
	private String suffix;
	
	public Method getSetter(boolean isOverride,boolean callSuper,String suffix){
		this.suffix = suffix;
		return getSetter(isOverride, callSuper);
	}
	@Override
	public String toString() {
		
		if (jtype!=null){
			return visibility+" "+jtype.getQualifiedSourceName()+" "+name+";";
		}else{
			return visibility+" "+type.getCanonicalName()+" "+name+";";			
		}

	}
	
}
