/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;


public class ForDeclaration {
	
	private Body body;
	private Class<?> type;
	private String varName;
	private String collectionDeclaration;
	
	public ForDeclaration(Class<?> type,String varName,String collectionDeclaration) {
		
		this.body 					= new Body();
		this.type 					= type;
		this.varName 				= varName;
		this.collectionDeclaration 	= collectionDeclaration;
		
	}
	
	public Body getBody() {
		return body;
	}
	
	@Override
	public String toString() {
		
		StringBuilder sb = new StringBuilder();
		String forDeclaration = "for(%s %s:%s){\n";
		sb.append(String.format(forDeclaration, this.type.getCanonicalName(),this.varName,this.collectionDeclaration));
		sb.append(body.toString()+"\n");
		sb.append("}\n");
		
		return sb.toString();
	}
	
	
}
