/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.helper;

import java.util.LinkedHashSet;
import java.util.Set;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JMethod;

public class JClassTypeHelper {
	
	private JClassType type;
	
	public JClassTypeHelper(JClassType type) {
		
		this.type = type;
		
	}
	
	/**
	 * Checks whether or not a method with the following name exists without 
	 * taking care of the method signature 
	 * @param methodName
	 * @return
	 */
	public boolean containsMethod(String methodName){
		
		for(JMethod m : type.getMethods()){
			
			if (m.getName().equals(methodName)){
				return true;
			}
			
		}
		
		return false;
	}
	
	
	public boolean implementsInterface(Class<?> interf8ce){
		
		for(JClassType i : this.type.getImplementedInterfaces()){
			
			if (i.getQualifiedSourceName().equals(interf8ce.getCanonicalName())){
				return true;
			}
		}
		
		return false;
	}
	
	
	/**
	 * Returns all fields of the type considering inheritance
	 * @return
	 */
	public Set<JField> getAllFields(){
		
		LinkedHashSet<JField> fields = new LinkedHashSet<JField>();
		
		JClassType currentType = type;
		
		while(currentType.getSuperclass()!=null){
			
			for(JField field : currentType.getFields()){
				if (fieldsContain(field, fields)==false) fields.add(field);				
			}

			currentType = currentType.getSuperclass();
		}
		
	return fields;	
	}
	
	private boolean fieldsContain(JField field,Set<JField> fields){
		
		for(JField f:fields){
			
			if (field.getName().equals(f.getName())){
				return true;
			}
			
		}
		
		return false;
	}
	
}
